-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  /   Vendor: Xilinx
-- \   \   \/    Version: 5.0
--  \   \        Filename: $RCSfile: floating_point_v5_0_xst_unobf.vhd,v $           
--  /   /        Date Last Modified: $Date: 2009/12/04 11:46:54 $ 
-- /___/   /\    Date Created: Dec 2005
-- \   \  /  \
--  \___\/\___\
-- 
--Device  : All
--Library : xilinxcorelib
--Purpose : Floating-point operator behavioral model
--
--------------------------------------------------------------------------------    
--  (c) Copyright 2005-2009 Xilinx, Inc. All rights reserved.
--
--  This file contains confidential and proprietary information
--  of Xilinx, Inc. and is protected under U.S. and
--  international copyright and other intellectual property
--  laws.
--
--  DISCLAIMER
--  This disclaimer is not a license and does not grant any
--  rights to the materials distributed herewith. Except as
--  otherwise provided in a valid license issued to you by
--  Xilinx, and to the maximum extent permitted by applicable
--  law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
--  WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
--  AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
--  BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
--  INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
--  (2) Xilinx shall not be liable (whether in contract or tort,
--  including negligence, or under any other theory of
--  liability) for any loss or damage of any kind or nature
--  related to, arising under or in connection with these
--  materials, including for any direct, or any indirect,
--  special, incidental, or consequential loss or damage
--  (including loss of data, profits, goodwill, or any type of
--  loss or damage suffered as a result of any action brought
--  by a third party) even if such damage or loss was
--  reasonably foreseeable or Xilinx had been advised of the
--  possibility of the same.
--
--  CRITICAL APPLICATIONS
--  Xilinx products are not designed or intended to be fail-
--  safe, or for use in any application requiring fail-safe
--  performance, such as life-support or safety devices or
--  systems, Class III medical devices, nuclear facilities,
--  applications related to the deployment of airbags, or any
--  other applications that could lead to death, personal
--  injury, or severe property or environmental damage
--  (individually and collectively, "Critical
--  Applications"). Customer assumes the sole risk and
--  liability of any use of Xilinx products in Critical
--  Applications, subject only to applicable laws and
--  regulations governing limitations on product liability.
--
--  THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
--  PART OF THIS FILE AT ALL TIMES. 
--------------------------------------------------------------------------------
--                               flt_pt_operator_v5_0
--  floating_point_v5_0_xst
--                                ND                    A  B
--    ND  A       B             /  |                    |  |
--    |   |       |            /   |                    |  |
--    |   |       |           /    +----------+         |  |  / flt_pt_sqrt
--  +-+---+-------+------+   /+----+----+ +---+---+ +---+--+-+  flt_pt_divide
--  | Optional signals   |  / |RDY_CNTRL| |RFD_GEN| |Function|  flt_pt_multiply
--  +---------+----------+ /  +----+----+ +---+---+ +----+---+  flt_pt_add
--            |           /        |          |          |    \   flt_pt_flt_to_fix
--  +---------+----------*    +----+----------+----------+--+  \  flt_pt_fix_to_flt
--  |flt_pt_operator_v5_0|    |        Delay  |             |   \ flt_pt_compare
--  +-+-------+----------*    +----+----------+----------+--+
--    |       |           \        |          |          |
--    |       |            \       |          |          |
--   RFD/RDY RESULT         \      |          |          |
--                           \     |          |          |
--                            \    |          |          |
--                             \   |          |          |
--                              \ RDY       RFD         RESULT
--                               \
--
--------------------------------------------------------------------------------

LIBRARY IEEE;USE IEEE.STD_LOGIC_1164.ALL;USE IEEE.STD_LOGIC_ARITH.ALL;LIBRARY XILINXCORELIB;USE XILINXCORELIB.
FLOATING_POINT_V5_0_CONSTS.ALL;USE XILINXCORELIB.FLOATING_POINT_PKG_V5_0.ALL;ENTITY FLT_PT_OPERATOR_V5_0 IS GENERIC(C_XDEVICEFAMILY
:STRING:=C_XDEVICEFAMILY_DEFAULT;C_HAS_ADD:INTEGER:=C_HAS_ADD_DEFAULT;C_HAS_SUBTRACT:INTEGER:=C_HAS_SUBTRACT_DEFAULT;C_HAS_MULTIPLY
:INTEGER:=C_HAS_MULTIPLY_DEFAULT;C_HAS_DIVIDE:INTEGER:=C_HAS_DIVIDE_DEFAULT;C_HAS_SQRT:INTEGER:=C_HAS_SQRT_DEFAULT;C_HAS_COMPARE:
INTEGER:=C_HAS_COMPARE_DEFAULT;C_HAS_FIX_TO_FLT:INTEGER:=C_HAS_FIX_TO_FLT_DEFAULT;C_HAS_FLT_TO_FIX:INTEGER:=C_HAS_FLT_TO_FIX_DEFAULT
;C_HAS_FLT_TO_FLT:INTEGER:=C_HAS_FLT_TO_FLT_DEFAULT;C_A_WIDTH:INTEGER:=C_A_WIDTH_DEFAULT;C_A_FRACTION_WIDTH:INTEGER:=
C_A_FRACTION_WIDTH_DEFAULT;C_B_WIDTH:INTEGER:=C_B_WIDTH_DEFAULT;C_B_FRACTION_WIDTH:INTEGER:=C_B_FRACTION_WIDTH_DEFAULT;
C_RESULT_WIDTH:INTEGER:=C_RESULT_WIDTH_DEFAULT;C_RESULT_FRACTION_WIDTH:INTEGER:=C_RESULT_FRACTION_WIDTH_DEFAULT;C_COMPARE_OPERATION
:INTEGER:=C_COMPARE_OPERATION_DEFAULT;C_LATENCY:INTEGER:=C_LATENCY_DEFAULT;C_OPTIMIZATION:INTEGER:=C_OPTIMIZATION_DEFAULT;
C_MULT_USAGE:INTEGER:=C_MULT_USAGE_DEFAULT;C_RATE:INTEGER:=C_RATE_DEFAULT;C_HAS_ACLR:INTEGER:=C_HAS_ACLR_DEFAULT;C_HAS_CE:INTEGER:=
C_HAS_CE_DEFAULT;C_HAS_SCLR:INTEGER:=C_HAS_SCLR_DEFAULT;C_HAS_A_NEGATE:INTEGER:=C_HAS_A_NEGATE_DEFAULT;C_HAS_B_NEGATE:INTEGER:=
C_HAS_B_NEGATE_DEFAULT;C_HAS_A_ND:INTEGER:=C_HAS_A_ND_DEFAULT;C_HAS_A_RFD:INTEGER:=C_HAS_A_RFD_DEFAULT;C_HAS_B_ND:INTEGER:=
C_HAS_B_ND_DEFAULT;C_HAS_B_RFD:INTEGER:=C_HAS_B_RFD_DEFAULT;C_HAS_OPERATION_ND:INTEGER:=C_HAS_OPERATION_ND_DEFAULT;
C_HAS_OPERATION_RFD:INTEGER:=C_HAS_OPERATION_RFD_DEFAULT;C_HAS_RDY:INTEGER:=C_HAS_RDY_DEFAULT;C_HAS_CTS:INTEGER:=C_HAS_CTS_DEFAULT;
C_HAS_UNDERFLOW:INTEGER:=C_HAS_UNDERFLOW_DEFAULT;C_HAS_OVERFLOW:INTEGER:=C_HAS_OVERFLOW_DEFAULT;C_HAS_INVALID_OP:INTEGER:=
C_HAS_INVALID_OP_DEFAULT;C_HAS_INEXACT:INTEGER:=C_HAS_INEXACT_DEFAULT;C_HAS_DIVIDE_BY_ZERO:INTEGER:=C_HAS_DIVIDE_BY_ZERO_DEFAULT;
C_HAS_STATUS:INTEGER:=C_HAS_STATUS_DEFAULT;C_HAS_EXCEPTION:INTEGER:=C_HAS_EXCEPTION_DEFAULT;C_STATUS_EARLY:INTEGER:=
C_STATUS_EARLY_DEFAULT;C_SPEED:INTEGER:=C_SPEED_DEFAULT;C_ROUNDING_MODE:INTEGER:=FLT_PT_RND_TO_NEAREST_EVEN);PORT(A:IN
 STD_LOGIC_VECTOR(C_A_WIDTH-1 DOWNTO 0);B:IN STD_LOGIC_VECTOR(C_B_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');A_NEGATE:IN STD_LOGIC:='0';
B_NEGATE:IN STD_LOGIC:='0';OPERATION:IN STD_LOGIC_VECTOR(FLT_PT_OPERATION_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');A_ND:IN STD_LOGIC:='1';
A_RFD:OUT STD_LOGIC;B_ND:IN STD_LOGIC:='1';B_RFD:OUT STD_LOGIC;OPERATION_ND:IN STD_LOGIC:='1';OPERATION_RFD:OUT STD_LOGIC;CLK:IN
 STD_LOGIC:='0';SCLR:IN STD_LOGIC:='0';ACLR:IN STD_LOGIC:='0';CE:IN STD_LOGIC:='1';RESULT:OUT STD_LOGIC_VECTOR(C_RESULT_WIDTH-1
 DOWNTO 0):=(OTHERS=>'0');STATUS:OUT STD_LOGIC_VECTOR(FLT_PT_STATUS_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');EXCEPTION:OUT STD_LOGIC;
UNDERFLOW:OUT STD_LOGIC:='0';OVERFLOW:OUT STD_LOGIC:='0';INVALID_OP:OUT STD_LOGIC:='0';INEXACT:OUT STD_LOGIC;DIVIDE_BY_ZERO:OUT
 STD_LOGIC:='0';RDY:OUT STD_LOGIC;CTS:IN STD_LOGIC:='1');END;ARCHITECTURE BEHAVIORAL OF FLT_PT_OPERATOR_V5_0 IS FUNCTION
 II1IOOO1II0l1lOl00I1O001I00O0IIIII(IO1lll0I0l0l1ll1O01Ol0III011IOIIII,IOO0111OO0lOOl10l1l000l0OlI0IIIIII:INTEGER;IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII:STD_LOGIC_VECTOR)RETURN BOOLEAN IS VARIABLE IOOOlI0llOIl11IO01100OI1llOIIOIIII:STD_LOGIC_VECTOR(IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII'length-1 DOWNTO 0
);VARIABLE IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII:STD_LOGIC_VECTOR(IO1lll0I0l0l1ll1O01Ol0III011IOIIII-1 DOWNTO 0);BEGIN IOOOlI0llOIl11IO01100OI1llOIIOIIII:=IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII;IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII:=IOOOlI0llOIl11IO01100OI1llOIIOIIII(IOOOlI0llOIl11IO01100OI1llOIIOIIII'left DOWNTO IOOOlI0llOIl11IO01100OI1llOIIOIIII'left-IO1lll0I0l0l1ll1O01Ol0III011IOIIII+1);RETURN(IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII(IO1lll0I0l0l1ll1O01Ol0III011IOIIII-2 DOWNTO IOO0111OO0lOOl10l1l000l0OlI0IIIIII
-1)=FLT_PT_ZERO(IO1lll0I0l0l1ll1O01Ol0III011IOIIII-IOO0111OO0lOOl10l1l000l0OlI0IIIIII-1 DOWNTO 0));END;PROCEDURE II1001IO0010Oll1I01lOI0I0IlIOIIIII(IO110I1O0010OIOlIO00l1IIOl0llIIIII:IN INTEGER;IIIOOIO01011011IOIIlllIIOO0l1IIIII:IN INTEGER;II1IOOO00I0OI0O01I000O100llOOIIIII:IN STD_LOGIC_VECTOR;II00OI0110lI1II101lO1OO00I10OIIIII:OUT STD_LOGIC_VECTOR
;II00OIlIlO101I0IIOO0O1I0ll0OIIIIII:OUT STD_LOGIC;IOOI1l1OO01O111lO010OlO1O0l0IIIIII:OUT STD_LOGIC;IO11OllII1lO110Ol0I0O00I01l00IIIII:OUT STD_LOGIC)IS CONSTANT III01lO1l00IOOO0O0I0O0I111O0IIIIII:INTEGER:=IIIOOIO01011011IOIIlllIIOO0l1IIIII;CONSTANT IO1I1l01l1OI111Ol0IO10110I11IOIIII:INTEGER:=IO110I1O0010OIOlIO00l1IIOl0llIIIII-IIIOOIO01011011IOIIlllIIOO0l1IIIII;
CONSTANT IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII:INTEGER:=2**(IO1I1l01l1OI111Ol0IO10110I11IOIIII-1)-1;CONSTANT IIIOI11O0OO00OllOllO00lOI000IOIIII:INTEGER:=2-2**(IO1I1l01l1OI111Ol0IO10110I11IOIIII-1);CONSTANT IIOIOOO11l0lO001OI10I0IIIIlIIIIIII:INTEGER:=2**(IO1I1l01l1OI111Ol0IO10110I11IOIIII-1)-1;VARIABLE II0IO0I0Olll01OOO0lIOO01lOlIOOIIII
:STD_LOGIC_VECTOR(III01lO1l00IOOO0O0I0O0I111O0IIIIII DOWNTO 0);VARIABLE IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII:STD_LOGIC_VECTOR(III01lO1l00IOOO0O0I0O0I111O0IIIIII+IO1I1l01l1OI111Ol0IO10110I11IOIIII-1 DOWNTO 0);VARIABLE II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII:STD_LOGIC:='0';VARIABLE IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII:
SIGNED(III01lO1l00IOOO0O0I0O0I111O0IIIIII DOWNTO 0);VARIABLE IO0O10O101OOIOOl10lIIO101lIIIIIIII:INTEGER;VARIABLE IIOl10001I1Ol001OIO01IO1II10OIIIII:INTEGER;VARIABLE IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII:STD_LOGIC_VECTOR(III01lO1l00IOOO0O0I0O0I111O0IIIIII DOWNTO 0);VARIABLE IIIIl1100lOI0I1OO1I00OlI0l10IIIIII
:STD_LOGIC;VARIABLE IOlI00I100IOOOl011O11IOI1l010IIIII:INTEGER;VARIABLE IIIO1O1110Oll10OI110OIIO111OOIIIII:SIGNED(III01lO1l00IOOO0O0I0O0I111O0IIIIII+3 DOWNTO 0);BEGIN II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII:='0';IIIO1O1110Oll10OI110OIIO111OOIIIII:=(OTHERS=>'0');II0IO0I0Olll01OOO0lIOO01lOlIOOIIII:=(OTHERS=>'0');IIOl10001I1Ol001OIO01IO1II10OIIIII
:=CONV_INTEGER(II1IOOO00I0OI0O01I000O100llOOIIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII+IO1I1l01l1OI111Ol0IO10110I11IOIIII-1));IF FLT_PT_IS_NAN(III01lO1l00IOOO0O0I0O0I111O0IIIIII+IO1I1l01l1OI111Ol0IO10110I11IOIIII,III01lO1l00IOOO0O0I0O0I111O0IIIIII,II1IOOO00I0OI0O01I000O100llOOIIIII)THEN IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII:=FLT_PT_GET_QUIET_NAN(III01lO1l00IOOO0O0I0O0I111O0IIIIII+IO1I1l01l1OI111Ol0IO10110I11IOIIII,III01lO1l00IOOO0O0I0O0I111O0IIIIII);ELSIF II1IOOO1II0l1lOl00I1O001I00O0IIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII
+IO1I1l01l1OI111Ol0IO10110I11IOIIII,III01lO1l00IOOO0O0I0O0I111O0IIIIII,II1IOOO00I0OI0O01I000O100llOOIIIII)THEN IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII:=FLT_PT_GET_ZERO(III01lO1l00IOOO0O0I0O0I111O0IIIIII+IO1I1l01l1OI111Ol0IO10110I11IOIIII,III01lO1l00IOOO0O0I0O0I111O0IIIIII,CONV_STD_LOGIC_VECTOR(IIOl10001I1Ol001OIO01IO1II10OIIIII,1)(0));ELSIF IIOl10001I1Ol001OIO01IO1II10OIIIII=1 THEN II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII:='1';IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII:=
FLT_PT_GET_QUIET_NAN(III01lO1l00IOOO0O0I0O0I111O0IIIIII+IO1I1l01l1OI111Ol0IO10110I11IOIIII,III01lO1l00IOOO0O0I0O0I111O0IIIIII);ELSIF FLT_PT_IS_INF(III01lO1l00IOOO0O0I0O0I111O0IIIIII+IO1I1l01l1OI111Ol0IO10110I11IOIIII,III01lO1l00IOOO0O0I0O0I111O0IIIIII,II1IOOO00I0OI0O01I000O100llOOIIIII)THEN IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII:=FLT_PT_GET_INF(III01lO1l00IOOO0O0I0O0I111O0IIIIII+IO1I1l01l1OI111Ol0IO10110I11IOIIII,III01lO1l00IOOO0O0I0O0I111O0IIIIII,CONV_STD_LOGIC_VECTOR(IIOl10001I1Ol001OIO01IO1II10OIIIII,1)(0
));ELSE IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII):='1';IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII-1 DOWNTO 1):=SIGNED(II1IOOO00I0OI0O01I000O100llOOIIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII-2 DOWNTO 0));IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII(0):='0';IO0O10O101OOIOOl10lIIO101lIIIIIIII:=CONV_INTEGER(UNSIGNED(II1IOOO00I0OI0O01I000O100llOOIIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII+IO1I1l01l1OI111Ol0IO10110I11IOIIII-2 DOWNTO III01lO1l00IOOO0O0I0O0I111O0IIIIII
-1)));IF IIOl10001I1Ol001OIO01IO1II10OIIIII=1 THEN IIIIl1100lOI0I1OO1I00OlI0l10IIIIII:='1';ELSE IIIIl1100lOI0I1OO1I00OlI0l10IIIIII:='0';END IF;IOlI00I100IOOOl011O11IOI1l010IIIII:=(IO0O10O101OOIOOl10lIIO101lIIIIIIII+IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII)/2;IF(IO0O10O101OOIOOl10lIIO101lIIIIIIII MOD 2=1)THEN IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII DOWNTO 0
):='0'&IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII DOWNTO 1);END IF;FOR IIl0OIlO00I0lI101l1I0lO1II0IlIIIII IN(III01lO1l00IOOO0O0I0O0I111O0IIIIII)DOWNTO 0 LOOP IIIO1O1110Oll10OI110OIIO111OOIIIII:=IIIO1O1110Oll10OI110OIIO111OOIIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII+1 DOWNTO 0)&SIGNED(IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII DOWNTO III01lO1l00IOOO0O0I0O0I111O0IIIIII-1));IF IIIO1O1110Oll10OI110OIIO111OOIIIII>=0 THEN IIIO1O1110Oll10OI110OIIO111OOIIIII:=IIIO1O1110Oll10OI110OIIO111OOIIIII-
SIGNED(EXT((II0IO0I0Olll01OOO0lIOO01lOlIOOIIII&"01"),III01lO1l00IOOO0O0I0O0I111O0IIIIII+3));ELSE IIIO1O1110Oll10OI110OIIO111OOIIIII:=IIIO1O1110Oll10OI110OIIO111OOIIIII+SIGNED(EXT((II0IO0I0Olll01OOO0lIOO01lOlIOOIIII&"11"),III01lO1l00IOOO0O0I0O0I111O0IIIIII+3));END IF;IF IIIO1O1110Oll10OI110OIIO111OOIIIII>=0 THEN II0IO0I0Olll01OOO0lIOO01lOlIOOIIII:=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII-1 DOWNTO 0)&'1';ELSE II0IO0I0Olll01OOO0lIOO01lOlIOOIIII:=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII-1
 DOWNTO 0)&'0';END IF;IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII DOWNTO 0):=IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII-2 DOWNTO 0)&"00";END LOOP;IF(II0IO0I0Olll01OOO0lIOO01lOlIOOIIII(0)='1')THEN IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII:=UNSIGNED(EXT(II0IO0I0Olll01OOO0lIOO01lOlIOOIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII DOWNTO 1
),III01lO1l00IOOO0O0I0O0I111O0IIIIII+1))+1;ELSE IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII:=EXT(II0IO0I0Olll01OOO0lIOO01lOlIOOIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII DOWNTO 1),III01lO1l00IOOO0O0I0O0I111O0IIIIII+1);END IF;IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII:=IIIIl1100lOI0I1OO1I00OlI0l10IIIIII&CONV_STD_LOGIC_VECTOR(IOlI00I100IOOOl011O11IOI1l010IIIII,IO1I1l01l1OI111Ol0IO10110I11IOIIII)&IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII(III01lO1l00IOOO0O0I0O0I111O0IIIIII-2 DOWNTO
 0);END IF;II00OI0110lI1II101lO1OO00I10OIIIII:=IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII;II00OIlIlO101I0IIOO0O1I0ll0OIIIIII:=II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII;IOOI1l1OO01O111lO010OlO1O0l0IIIIII:='0';IO11OllII1lO110Ol0I0O00I01l00IIIII:='0';END;PROCEDURE IOIlII1I0O0l1l1O110O0IOlO0O1lIIIII(II11I0011I0IIIl0100l1O01O01O0IIIII:IN INTEGER;II011lO0O1l10O0I0OIOO000I0O1IOIIII:IN INTEGER;IO1IIIl1OO00II0ll110l0l0IIO0lIIIII:IN
 STD_LOGIC_VECTOR;IIlOllOOI0ll11O1101IIl0l11ll1IIIII:IN STD_LOGIC_VECTOR;II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:OUT STD_LOGIC_VECTOR;III1OO10l11110IO1IO0lOII0OO11IIIII:OUT STD_LOGIC;IO1O1llOO0IlllI1O1OlOI010l1IIIIIII:OUT STD_LOGIC;IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII:OUT
 STD_LOGIC;II1IO01lI1IO1OII11O1II01I0llIOIIII:OUT STD_LOGIC)IS CONSTANT II1lIII001001Il0l0OOl0I00I01IIIIII:INTEGER:=II011lO0O1l10O0I0OIOO000I0O1IOIIII;CONSTANT II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII:INTEGER:=II11I0011I0IIIl0100l1O01O01O0IIIII-II011lO0O1l10O0I0OIOO000I0O1IOIIII;CONSTANT IOII100I0I1l010IOI1lO1O1I1101IIIII:INTEGER:=2**(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII-1)-
1;CONSTANT IOO10OI11Il110I11IIIIIOIO10OlIIIII:INTEGER:=2-2**(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII-1);CONSTANT IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII:INTEGER:=2**(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII-1)-1;VARIABLE IOl0l10lI11IO10lI1OI1IOI01OO0IIIII:STD_LOGIC_VECTOR(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+1 DOWNTO 0);
VARIABLE IOO1l1010O10O10I0llO11O100O1IOIIII:STD_LOGIC_VECTOR(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+1 DOWNTO 0);VARIABLE IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII:STD_LOGIC_VECTOR(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+1 DOWNTO 0);VARIABLE II0IOOI1Il101lO1O010O0O0IO10IOIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII-1
 DOWNTO 0);VARIABLE IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII-1 DOWNTO 0);VARIABLE IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII-1 DOWNTO 0);VARIABLE II111OIOII1IIOOOlO1I011OI0I0lIIIII:STD_LOGIC;
VARIABLE III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII:STD_LOGIC;VARIABLE IIIIlI10IO0IlIll11O0O1OII0OIIOIIII:STD_LOGIC;VARIABLE IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII:BOOLEAN;VARIABLE IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII:BOOLEAN;VARIABLE IIl1O1I0001l1001OllOOII0I10l1IIIII:BOOLEAN;VARIABLE IIlIlll0III10I0Il0I0OOOIOIIOOIIIII:
BOOLEAN;VARIABLE IOOI10l0O1lIlIll00Ol1lll10IIIIIIII:BOOLEAN;VARIABLE IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII:BOOLEAN;CONSTANT IOl0I10010lIIIl000I1O1IO1IlOIIIIII:INTEGER:=2;VARIABLE IOl1I1O0IIO001llOlll1I1lOI1l0IIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII-1 DOWNTO 0);
VARIABLE IOl1Ol11IlIl0110l0OOll000lI11IIIII:STD_LOGIC;VARIABLE II001Il0III1O1OI001IOI100000OIIIII:STD_LOGIC;VARIABLE IOOl0llO0OI110111OIOlOIO0lOOIOIIII:STD_LOGIC;VARIABLE II1IOO1l1I11I1ll1OI1I00lII000IIIII:STD_LOGIC;
VARIABLE II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII-1+IOl0I10010lIIIl000I1O1IO1IlOIIIIII+1 DOWNTO 0);VARIABLE IOOl0IOOO1011llOIOl01lIOI0O11IIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII-1 DOWNTO 0);VARIABLE IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII+1
 DOWNTO 0);VARIABLE II1I0O0100lIIII11lI00l0OOII0lIIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII+1 DOWNTO 0);VARIABLE IIOIOI0lO1lO100O11Il0OII11OlOIIIII:STD_LOGIC;VARIABLE IO0IlO1lI10Il011101l101IIl0IOIIIII:STD_LOGIC;VARIABLE IOI1O00I10101l0I1001llOOI0I0IOIIII:STD_LOGIC;VARIABLE
 IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII+1 DOWNTO 0);VARIABLE IO1Il1I0OOOOIl0IOO011l1I0111OIIIII:STD_LOGIC;VARIABLE IO0l0IOllOl1100O10O1O1l0lIO1OIIIII:STD_LOGIC;BEGIN IOl1Ol11IlIl0110l0OOll000lI11IIIII:='0';II001Il0III1O1OI001IOI100000OIIIII:='0'
;IOOl0llO0OI110111OIOlOIO0lOOIOIIII:='0';II1IOO1l1I11I1ll1OI1I00lII000IIIII:='0';II111OIOII1IIOOOlO1I011OI0I0lIIIII:=IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+II1lIII001001Il0l0OOl0I00I01IIIIII-1);IOl0l10lI11IO10lI1OI1IOI01OO0IIIII:=EXT(IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+II1lIII001001Il0l0OOl0I00I01IIIIII-2 DOWNTO II1lIII001001Il0l0OOl0I00I01IIIIII-1),II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+2);II0IOOI1Il101lO1O010O0O0IO10IOIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-1 DOWNTO 0):='1'&IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-2
 DOWNTO 0);III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII:=IIlOllOOI0ll11O1101IIl0l11ll1IIIII(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+II1lIII001001Il0l0OOl0I00I01IIIIII-1);IOO1l1010O10O10I0llO11O100O1IOIIII:=EXT(IIlOllOOI0ll11O1101IIl0l11ll1IIIII(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+II1lIII001001Il0l0OOl0I00I01IIIIII-2 DOWNTO II1lIII001001Il0l0OOl0I00I01IIIIII-1),II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+2);IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-1 DOWNTO 0):='1'&IIlOllOOI0ll11O1101IIl0l11ll1IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-2 DOWNTO 0);IIIIlI10IO0IlIll11O0O1OII0OIIOIIII:=(II111OIOII1IIOOOlO1I011OI0I0lIIIII XOR
 III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII);IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII:=FLT_PT_IS_INF(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IO1IIIl1OO00II0ll110l0l0IIO0lIIIII);IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII:=FLT_PT_IS_NAN(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IO1IIIl1OO00II0ll110l0l0IIO0lIIIII);IIl1O1I0001l1001OllOOII0I10l1IIIII:=II1IOOO1II0l1lOl00I1O001I00O0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IO1IIIl1OO00II0ll110l0l0IIO0lIIIII);IIlIlll0III10I0Il0I0OOOIOIIOOIIIII:=
FLT_PT_IS_INF(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIlOllOOI0ll11O1101IIl0l11ll1IIIII);IOOI10l0O1lIlIll00Ol1lll10IIIIIIII:=FLT_PT_IS_NAN(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIlOllOOI0ll11O1101IIl0l11ll1IIIII);IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII:=II1IOOO1II0l1lOl00I1O001I00O0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIlOllOOI0ll11O1101IIl0l11ll1IIIII);IF(IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII OR IOOI10l0O1lIlIll00Ol1lll10IIIIIIII)THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=
FLT_PT_GET_QUIET_NAN(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII);ELSIF IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII THEN IF IIlIlll0III10I0Il0I0OOOIOIIOOIIIII THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_QUIET_NAN(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII);IOl1Ol11IlIl0110l0OOll000lI11IIIII:='1';ELSIF IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII
:=FLT_PT_GET_INF(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);ELSE II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_INF(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);END IF;ELSIF IIl1O1I0001l1001OllOOII0I10l1IIIII THEN IF IIlIlll0III10I0Il0I0OOOIOIIOOIIIII THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_ZERO(II1lIII001001Il0l0OOl0I00I01IIIIII+
II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);ELSIF IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_QUIET_NAN(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII);IOl1Ol11IlIl0110l0OOll000lI11IIIII:='1';ELSE II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_ZERO(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);END IF;
ELSE IF IIlIlll0III10I0Il0I0OOOIOIIOOIIIII THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_ZERO(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);ELSIF IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_INF(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);II1IOO1l1I11I1ll1OI1I00lII000IIIII:='1';ELSE IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII
:=SIGNED(IOl0l10lI11IO10lI1OI1IOI01OO0IIIII)-SIGNED(IOO1l1010O10O10I0llO11O100O1IOIIII);IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-1 DOWNTO 0):=II0IOOI1Il101lO1O010O0O0IO10IOIIII;IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+1 DOWNTO II1lIII001001Il0l0OOl0I00I01IIIIII):=(OTHERS=>'0');II1I0O0100lIIII11lI00l0OOII0lIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-1 DOWNTO 0):=IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII;II1I0O0100lIIII11lI00l0OOII0lIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+1 DOWNTO II1lIII001001Il0l0OOl0I00I01IIIIII
):=(OTHERS=>'0');FOR IIlOO000I01110Ill0l1OI1l10IOIOIIII IN II1lIII001001Il0l0OOl0I00I01IIIIII+IOl0I10010lIIIl000I1O1IO1IlOIIIIII DOWNTO 1 LOOP IF IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+1)='0'THEN IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:=SIGNED(IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII)-SIGNED(II1I0O0100lIIII11lI00l0OOII0lIIIII);II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(IIlOO000I01110Ill0l1OI1l10IOIOIIII):='1';ELSE IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:=SIGNED(IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII)+
SIGNED(II1I0O0100lIIII11lI00l0OOII0lIIIII);II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(IIlOO000I01110Ill0l1OI1l10IOIOIIII):='0';END IF;IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+1 DOWNTO 1):=IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII DOWNTO 0);IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(0):='0';END LOOP;IF IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+1)='0'THEN IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:=SIGNED(IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII)-SIGNED
(II1I0O0100lIIII11lI00l0OOII0lIIIII);II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(0):='1';ELSE IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:=SIGNED(IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII)+SIGNED(II1I0O0100lIIII11lI00l0OOII0lIIIII);II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(0):='0';END IF;II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+IOl0I10010lIIIl000I1O1IO1IlOIIIIII DOWNTO 0):=II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-1+IOl0I10010lIIIl000I1O1IO1IlOIIIIII DOWNTO 0)&'1';IIOIOI0lO1lO100O11Il0OII11OlOIIIII:=II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+IOl0I10010lIIIl000I1O1IO1IlOIIIIII);
IF(IIOIOI0lO1lO100O11Il0OII11OlOIIIII='1')THEN IO1Il1I0OOOOIl0IOO011l1I0111OIIIII:=II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(IOl0I10010lIIIl000I1O1IO1IlOIIIIII);IOOl0IOOO1011llOIOl01lIOI0O11IIIII:=UNSIGNED(II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+IOl0I10010lIIIl000I1O1IO1IlOIIIIII DOWNTO IOl0I10010lIIIl000I1O1IO1IlOIIIIII+1))+IO1Il1I0OOOOIl0IOO011l1I0111OIIIII;ELSE IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII:=SIGNED(IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII)-1;IO1Il1I0OOOOIl0IOO011l1I0111OIIIII:=II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(IOl0I10010lIIIl000I1O1IO1IlOIIIIII-1);IOOl0IOOO1011llOIOl01lIOI0O11IIIII:=
UNSIGNED(II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+IOl0I10010lIIIl000I1O1IO1IlOIIIIII-1 DOWNTO IOl0I10010lIIIl000I1O1IO1IlOIIIIII))+IO1Il1I0OOOOIl0IOO011l1I0111OIIIII;END IF;IF CONV_INTEGER(SIGNED(IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII))>IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII THEN IOl1I1O0IIO001llOlll1I1lOI1l0IIIII:=FLT_PT_GET_INF(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);
II001Il0III1O1OI001IOI100000OIIIII:='1';ELSIF CONV_INTEGER(SIGNED(IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII))<IOO10OI11Il110I11IIIIIOIO10OlIIIII THEN IOl1I1O0IIO001llOlll1I1lOI1l0IIIII:=FLT_PT_GET_ZERO(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);IOOl0llO0OI110111OIOlOIO0lOOIOIIII:='1';ELSE
 IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII:=SIGNED(IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII)+IOII100I0I1l010IOI1lO1O1I1101IIIII;IOl1I1O0IIO001llOlll1I1lOI1l0IIIII:=IIIIlI10IO0IlIll11O0O1OII0OIIOIIII&IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII-1 DOWNTO 0)&IOOl0IOOO1011llOIOl01lIOI0O11IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-2 DOWNTO 0);END IF;II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=IOl1I1O0IIO001llOlll1I1lOI1l0IIIII;END IF;END IF;III1OO10l11110IO1IO0lOII0OO11IIIII:=
IOl1Ol11IlIl0110l0OOll000lI11IIIII;II1IO01lI1IO1OII11O1II01I0llIOIIII:=II1IOO1l1I11I1ll1OI1I00lII000IIIII;IO1O1llOO0IlllI1O1OlOI010l1IIIIIII:=II001Il0III1O1OI001IOI100000OIIIII;IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII:=IOOl0llO0OI110111OIOlOIO0lOOIOIIII;END;PROCEDURE II1011O1IO1l0llOI11lIIOIlOlIlIIIII(IOO0I1l1IOO0II0O00I0IllOOI1OOIIIII:IN
 INTEGER;IOI01l1I0000lIO0IIO01IlIO1001IIIII:IN INTEGER;IOI0IIll0I0l1IO0I01lO110IIIIIOIIII:IN STD_LOGIC_VECTOR;IO00l1I0I1IOlII011Il0l0lOI0OIIIIII:IN STD_LOGIC_VECTOR;IO01l1ll0IlOll0I00lll11l0OllIIIIII:OUT STD_LOGIC_VECTOR;IOI11IOIlOI1II1Il11OlI01Illl0IIIII:OUT STD_LOGIC;IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII:OUT
 STD_LOGIC;IOlIOOI0O1OIlOl01O0OIII10O11lIIIII:OUT STD_LOGIC)IS CONSTANT IO1OIOI0I1l11O0IllIOllII1llIIOIIII:INTEGER:=IOI01l1I0000lIO0IIO01IlIO1001IIIII;CONSTANT IIOOO0OOIll110IlI1111I1001I01IIIII:INTEGER:=IOO0I1l1IOO0II0O00I0IllOOI1OOIIIII-IOI01l1I0000lIO0IIO01IlIO1001IIIII;CONSTANT IO00lII1lIll0OllOlI1l1O0OI100IIIII:INTEGER:=2**(IIOOO0OOIll110IlI1111I1001I01IIIII-1)-1;
CONSTANT IIII1llIll1l01O1l1O0OIlO1l00OIIIII:INTEGER:=2-2**(IIOOO0OOIll110IlI1111I1001I01IIIII-1);CONSTANT II10ll00IlO1IIOIOIO10II0lI1l0IIIII:INTEGER:=2**(IIOOO0OOIll110IlI1111I1001I01IIIII-1)-1;VARIABLE IOIIOIIO1lIIOOl0IlO11I00II110IIIII,II0Ol0OI111lIO001O0IIlO110IlIOIIII,II1ll00lO01110lOI1I0IOO0IlO0IIIIII:STD_LOGIC_VECTOR(IIOOO0OOIll110IlI1111I1001I01IIIII+1 DOWNTO 0);
VARIABLE IO0I011OOl0OOO000O0I0O0OO0OllIIIII,IO1OllI0IIll0OIOI1l01I010OOIOOIIII,IIOl11l1l101llOl0l0l101I1O1llIIIII:STD_LOGIC_VECTOR(IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1 DOWNTO 0);VARIABLE III1O0Ol0IOOO0IllIOOO000O1lO0IIIII,IIl1IIO111llI0l1O1OI00lIl1I0OIIIII,IIIOOI1II1O11lOIOlOIlOOII1010IIIII:STD_LOGIC;VARIABLE IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII:STD_LOGIC_VECTOR(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1 DOWNTO 0);
VARIABLE IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII:STD_LOGIC_VECTOR(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1 DOWNTO 0);VARIABLE IOOI0OO0l1O1O000lO10OOllOIIIIOIIII:STD_LOGIC;VARIABLE IO1IllOO0II1ll1OII0OOO10OO0I1IIIII:STD_LOGIC_VECTOR(IO1OIOI0I1l11O0IllIOllII1llIIOIIII DOWNTO 0);VARIABLE IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII:
STD_LOGIC_VECTOR(IIOOO0OOIll110IlI1111I1001I01IIIII+1+IO1OIOI0I1l11O0IllIOllII1llIIOIIII DOWNTO 0):=(OTHERS=>'0');VARIABLE IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII:STD_LOGIC_VECTOR(IIOOO0OOIll110IlI1111I1001I01IIIII+1+IO1OIOI0I1l11O0IllIOllII1llIIOIIII DOWNTO 0):=(OTHERS=>'1');VARIABLE II10110Oll1OOlIOlOlIl01111IlOIIIII
:STD_LOGIC;VARIABLE IOIO00lO11l0IOO1l0I101I11l1OOIIIII:STD_LOGIC;VARIABLE IIIIl0I1lO1llIOIOOO1lOl11IIlOIIIII:STD_LOGIC;VARIABLE II0l0O0IOlIOI00OIl0IlOlI01OI1IIIII:STD_LOGIC;VARIABLE IIlO0l11I10OOIl000I0OOIO0IO0IIIIII:STD_LOGIC;VARIABLE
 IIOIOOI1ll1O0I1011l0O1lI0IllIOIIII:STD_LOGIC;VARIABLE IOIlllIIlI1OlI0l101llI0II1O1IOIIII:BOOLEAN;VARIABLE IOO0IO0OOOOO0I10II0llO10ll1OlIIIII:BOOLEAN;VARIABLE IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII:BOOLEAN;VARIABLE IOl10OI01O100l1IIIl0IIl1lO10lIIIII:BOOLEAN;VARIABLE IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII:BOOLEAN;
VARIABLE IO00l1II1l000l0I11O010I1IlOlIOIIII:BOOLEAN;VARIABLE II0IO0O1III0I1I1OlI0011O001IOIIIII:BOOLEAN;VARIABLE IIl1OOO111O0O11l1OOllOIIIIIl0IIIII:BOOLEAN;VARIABLE IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII:BOOLEAN;VARIABLE IOl1I001lIl1Il1I11lI00l11O1OOIIIII:STD_LOGIC;VARIABLE IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII:
STD_LOGIC;VARIABLE III0l0O0I11OOO1lI0OOIO0llOlIlIIIII:STD_LOGIC;VARIABLE IOO01101I01OlOIO111IIl0OOIOI0IIIII:STD_LOGIC;VARIABLE II00l0IOI1lIlOlOOI0I011O1110OIIIII:STD_LOGIC;BEGIN IOIIOIIO1lIIOOl0IlO11I00II110IIIII:=EXT(IOI0IIll0I0l1IO0I01lO110IIIIIOIIII(IIOOO0OOIll110IlI1111I1001I01IIIII+IO1OIOI0I1l11O0IllIOllII1llIIOIIII-2 DOWNTO IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1),IIOOO0OOIll110IlI1111I1001I01IIIII+2);III1O0Ol0IOOO0IllIOOO000O1lO0IIIII
:=IOI0IIll0I0l1IO0I01lO110IIIIIOIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IIOOO0OOIll110IlI1111I1001I01IIIII-1);IO0I011OOl0OOO000O0I0O0OO0OllIIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1 DOWNTO 0):='1'&IOI0IIll0I0l1IO0I01lO110IIIIIOIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII-2 DOWNTO 0);II0Ol0OI111lIO001O0IIlO110IlIOIIII:=EXT(IO00l1I0I1IOlII011Il0l0lOI0OIIIIII(IIOOO0OOIll110IlI1111I1001I01IIIII+IO1OIOI0I1l11O0IllIOllII1llIIOIIII-2 DOWNTO IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1),IIOOO0OOIll110IlI1111I1001I01IIIII+2);IIl1IIO111llI0l1O1OI00lIl1I0OIIIII:=IO00l1I0I1IOlII011Il0l0lOI0OIIIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IIOOO0OOIll110IlI1111I1001I01IIIII-1);IO1OllI0IIll0OIOI1l01I010OOIOOIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1 DOWNTO 0):='1'&IO00l1I0I1IOlII011Il0l0lOI0OIIIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII
-2 DOWNTO 0);IIIOOI1II1O11lOIOlOIlOOII1010IIIII:=(III1O0Ol0IOOO0IllIOOO000O1lO0IIIII XOR IIl1IIO111llI0l1O1OI00lIl1I0OIIIII);IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII:=FLT_PT_IS_INF(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IIOOO0OOIll110IlI1111I1001I01IIIII,IO1OIOI0I1l11O0IllIOllII1llIIOIIII,IOI0IIll0I0l1IO0I01lO110IIIIIOIIII);IOIlllIIlI1OlI0l101llI0II1O1IOIIII:=FLT_PT_IS_NAN(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IIOOO0OOIll110IlI1111I1001I01IIIII,IO1OIOI0I1l11O0IllIOllII1llIIOIIII,IOI0IIll0I0l1IO0I01lO110IIIIIOIIII);IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII:=II1IOOO1II0l1lOl00I1O001I00O0IIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IIOOO0OOIll110IlI1111I1001I01IIIII,
IO1OIOI0I1l11O0IllIOllII1llIIOIIII,IOI0IIll0I0l1IO0I01lO110IIIIIOIIII);IOl10OI01O100l1IIIl0IIl1lO10lIIIII:=FLT_PT_IS_INF(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IIOOO0OOIll110IlI1111I1001I01IIIII,IO1OIOI0I1l11O0IllIOllII1llIIOIIII,IO00l1I0I1IOlII011Il0l0lOI0OIIIIII);IOO0IO0OOOOO0I10II0llO10ll1OlIIIII:=FLT_PT_IS_NAN(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IIOOO0OOIll110IlI1111I1001I01IIIII,IO1OIOI0I1l11O0IllIOllII1llIIOIIII,IO00l1I0I1IOlII011Il0l0lOI0OIIIIII);IO00l1II1l000l0I11O010I1IlOlIOIIII:=II1IOOO1II0l1lOl00I1O001I00O0IIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IIOOO0OOIll110IlI1111I1001I01IIIII,IO1OIOI0I1l11O0IllIOllII1llIIOIIII,IO00l1I0I1IOlII011Il0l0lOI0OIIIIII);III0l0O0I11OOO1lI0OOIO0llOlIlIIIII:='0';IOl1I001lIl1Il1I11lI00l11O1OOIIIII
:='0';IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII:='0';II0IO0O1III0I1I1OlI0011O001IOIIIII:=FALSE;IIl1OOO111O0O11l1OOllOIIIIIl0IIIII:=FALSE;IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII:=FALSE;IF IOIlllIIlI1OlI0l101llI0II1O1IOIIII OR IOO0IO0OOOOO0I10II0llO10ll1OlIIIII THEN II0IO0O1III0I1I1OlI0011O001IOIIIII:=TRUE;ELSIF(IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII AND IO00l1II1l000l0I11O010I1IlOlIOIIII)OR(IOl10OI01O100l1IIIl0IIl1lO10lIIIII AND IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII)THEN
 II0IO0O1III0I1I1OlI0011O001IOIIIII:=TRUE;III0l0O0I11OOO1lI0OOIO0llOlIlIIIII:='1';ELSIF IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII OR IOl10OI01O100l1IIIl0IIl1lO10lIIIII THEN IIl1OOO111O0O11l1OOllOIIIIIl0IIIII:=TRUE;ELSIF IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII OR IO00l1II1l000l0I11O010I1IlOlIOIIII THEN IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII:=TRUE;ELSE II1ll00lO01110lOI1I0IOO0IlO0IIIIII:=SIGNED(IOIIOIIO1lIIOOl0IlO11I00II110IIIII)+SIGNED(II0Ol0OI111lIO001O0IIlO110IlIOIIII)+1-
IO00lII1lIll0OllOlI1l1O0OI100IIIII;IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII:=UNSIGNED(IO0I011OOl0OOO000O0I0O0OO0OllIIIII)*UNSIGNED(IO1OllI0IIll0OIOI1l01I010OOIOOIIII);IF IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1)='0'THEN IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1 DOWNTO 0):=IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IO1OIOI0I1l11O0IllIOllII1llIIOIIII-2 DOWNTO 0)&'0';II1ll00lO01110lOI1I0IOO0IlO0IIIIII:=SIGNED(II1ll00lO01110lOI1I0IOO0IlO0IIIIII)-1
;ELSE IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII:=IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII;END IF;IF(IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII-2 DOWNTO 0)=IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII-2 DOWNTO 0))THEN IOOI0OO0l1O1O000lO10OOllOIIIIOIIII:='1';ELSE IOOI0OO0l1O1O000lO10OOllOIIIIOIIII:='0';END IF;IF(IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1)='1'AND IOOI0OO0l1O1O000lO10OOllOIIIIOIIII
='0')OR(IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1)='1'AND IOOI0OO0l1O1O000lO10OOllOIIIIOIIII='1'AND IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII)='1')THEN IO1IllOO0II1ll1OII0OOO10OO0I1IIIII:=UNSIGNED(EXT(IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1 DOWNTO IO1OIOI0I1l11O0IllIOllII1llIIOIIII),IO1OIOI0I1l11O0IllIOllII1llIIOIIII+1))+1;ELSE IO1IllOO0II1ll1OII0OOO10OO0I1IIIII:=EXT(IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1
 DOWNTO IO1OIOI0I1l11O0IllIOllII1llIIOIIII),IO1OIOI0I1l11O0IllIOllII1llIIOIIII+1);END IF;IF IO1IllOO0II1ll1OII0OOO10OO0I1IIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII)='1'THEN IIOl11l1l101llOl0l0l101I1O1llIIIII:=IO1IllOO0II1ll1OII0OOO10OO0I1IIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII DOWNTO 1);II1ll00lO01110lOI1I0IOO0IlO0IIIIII:=SIGNED(II1ll00lO01110lOI1I0IOO0IlO0IIIIII)+1;ELSE IIOl11l1l101llOl0l0l101I1O1llIIIII:=IO1IllOO0II1ll1OII0OOO10OO0I1IIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII-1 DOWNTO 0);END IF;IOl1I001lIl1Il1I11lI00l11O1OOIIIII:='0';IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII
:='0';IF SIGNED(II1ll00lO01110lOI1I0IOO0IlO0IIIIII)<=SIGNED(IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII(IIOOO0OOIll110IlI1111I1001I01IIIII+1 DOWNTO 0))THEN IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII:=TRUE;IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII:='1';ELSIF II1ll00lO01110lOI1I0IOO0IlO0IIIIII(IIOOO0OOIll110IlI1111I1001I01IIIII+1 DOWNTO IIOOO0OOIll110IlI1111I1001I01IIIII)="01"OR(II1ll00lO01110lOI1I0IOO0IlO0IIIIII(IIOOO0OOIll110IlI1111I1001I01IIIII-1 DOWNTO 0)=NOT
 IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII(IIOOO0OOIll110IlI1111I1001I01IIIII-1 DOWNTO 0))THEN IIl1OOO111O0O11l1OOllOIIIIIl0IIIII:=TRUE;IOl1I001lIl1Il1I11lI00l11O1OOIIIII:='1';END IF;END IF;IF II0IO0O1III0I1I1OlI0011O001IOIIIII THEN IO01l1ll0IlOll0I00lll11l0OllIIIIII:=FLT_PT_GET_QUIET_NAN(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IIOOO0OOIll110IlI1111I1001I01IIIII,IO1OIOI0I1l11O0IllIOllII1llIIOIIII);ELSIF IIl1OOO111O0O11l1OOllOIIIIIl0IIIII THEN IO01l1ll0IlOll0I00lll11l0OllIIIIII:=
FLT_PT_GET_INF(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IIOOO0OOIll110IlI1111I1001I01IIIII,IO1OIOI0I1l11O0IllIOllII1llIIOIIII,IIIOOI1II1O11lOIOlOIlOOII1010IIIII);ELSIF IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII THEN IO01l1ll0IlOll0I00lll11l0OllIIIIII:=FLT_PT_GET_ZERO(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IIOOO0OOIll110IlI1111I1001I01IIIII,IO1OIOI0I1l11O0IllIOllII1llIIOIIII,IIIOOI1II1O11lOIOlOIlOOII1010IIIII);ELSE IO01l1ll0IlOll0I00lll11l0OllIIIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII+IIOOO0OOIll110IlI1111I1001I01IIIII-1 DOWNTO 0):=IIIOOI1II1O11lOIOlOIlOOII1010IIIII&II1ll00lO01110lOI1I0IOO0IlO0IIIIII(IIOOO0OOIll110IlI1111I1001I01IIIII-1 DOWNTO 0)&IIOl11l1l101llOl0l0l101I1O1llIIIII(IO1OIOI0I1l11O0IllIOllII1llIIOIIII-2
 DOWNTO 0);END IF;IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII:=IOl1I001lIl1Il1I11lI00l11O1OOIIIII;IOlIOOI0O1OIlOl01O0OIII10O11lIIIII:=IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII;IOI11IOIlOI1II1Il11OlI01Illl0IIIII:=III0l0O0I11OOO1lI0OOIO0llOlIlIIIII;END;PROCEDURE IOIO1OI0IlI1I1010lO000IO01Ol0IIIII(IIO00Il10lI0OOllOOO0lO11lOOlIOIIII:IN INTEGER;IIIIOOlIIO11011I1IlOO10OOOO0OIIIII:IN INTEGER;IIO0101IlI11I0IOlI01l1ll0O10OIIIII:
IN BOOLEAN;IOl00OIO0IOOllO1I1O101lIIl11OIIIII:IN STD_LOGIC_VECTOR;IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII:IN STD_LOGIC_VECTOR;IO00OI0ll1l1l0llI1I000OOO0010IIIII:OUT STD_LOGIC_VECTOR;IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII:OUT STD_LOGIC;IOI0111Il0IllIIO0O0lO0I111010IIIII:OUT STD_LOGIC;
IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII:OUT STD_LOGIC)IS CONSTANT IOO0llOIlIO0110l1lOO01I00l1OIIIIII:INTEGER:=IIIIOOlIIO11011I1IlOO10OOOO0OIIIII;CONSTANT IOIO0OOIOIOl0OIllO011O11O0OOIIIIII:INTEGER:=IIO00Il10lI0OOllOOO0lO11lOOlIOIIII-IIIIOOlIIO11011I1IlOO10OOOO0OIIIII;CONSTANT IO0lI0OlO11O10O1III000O01l0l0IIIII:INTEGER:=2**(IOIO0OOIOIOl0OIllO011O11O0OOIIIIII-1)-1;CONSTANT
 IIO1O00llO01OII1I11lIIO001lI0IIIII:INTEGER:=2-2**(IOIO0OOIOIOl0OIllO011O11O0OOIIIIII-1);CONSTANT IOIl1lI1IO111IO0OII101O1I0l0IOIIII:INTEGER:=2**(IOIO0OOIOIOl0OIllO011O11O0OOIIIIII-1)-1;CONSTANT IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII:SIGNED(IOO0llOIlIO0110l1lOO01I00l1OIIIIII-1 DOWNTO 0):=(OTHERS=>'0');
CONSTANT IO01O100lOO0IOOI000OO1lIOO1l0IIIII:SIGNED(IOO0llOIlIO0110l1lOO01I00l1OIIIIII DOWNTO 0):='1'&IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII;CONSTANT IOl1100I00OlIllOI1I0III1O1l01IIIII:SIGNED(IOO0llOIlIO0110l1lOO01I00l1OIIIIII DOWNTO 0):=(OTHERS=>'0');CONSTANT
 IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII:SIGNED(IOO0llOIlIO0110l1lOO01I00l1OIIIIII DOWNTO 0):=(OTHERS=>'0');CONSTANT IIOIlOO1lI01O10O1Ol0OOI10110OIIIII:SIGNED(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII+3-1 DOWNTO 0):=IOl1100I00OlIllOI1I0III1O1l01IIIII&'1'&IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII;CONSTANT
 IO0II1lll1llOlO1lll1001O1IlOIOIIII:SIGNED(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII+2 DOWNTO 0):=(OTHERS=>'0');VARIABLE IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:STD_LOGIC_VECTOR(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII-1 DOWNTO 0);VARIABLE IIlIIII1lOllO0IlO11I1O01110IOIIIII:STD_LOGIC;
VARIABLE II0I1I1l00l1O11OOIOIIllII10IlIIIII:STD_LOGIC;VARIABLE III0lIIOOIOl0ll0ll0l1lO10IlIIIIIII:STD_LOGIC;VARIABLE III010I1Ol1OlOI0IO10O0000II11IIIII:SIGNED(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII+2 DOWNTO 0);VARIABLE IOIlOO00I1I00lO00l0I00OlIO01IIIIII:SIGNED(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII+2 DOWNTO
 0);VARIABLE IIO111Il00001lO0l00lOOlI1IO10IIIII:INTEGER;VARIABLE II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:INTEGER;VARIABLE IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII:INTEGER;VARIABLE IO0I10OO0llIIlII1I01OOI001IIIIIIII:INTEGER;VARIABLE II110IlI0l101IO1IlI1O00llI00OIIIII:INTEGER;VARIABLE
 III0O000IO1IOIO10l0I00lOIII11IIIII:SIGNED(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII+2 DOWNTO 0);VARIABLE II1llIOlOlll00O010O1lI1IOI1I1IIIII:STD_LOGIC;VARIABLE IO1I11OIllI1III1III11OlIIlIIOIIIII:INTEGER;VARIABLE IIl11lIlOO0IIII0IOlI0l1000I1IIIIII:INTEGER;VARIABLE IOOI10l11llO01llIIllOI1IO0l1OIIIII:
BOOLEAN;VARIABLE IOO1IIll11IlI110IOlllI1Il1IO1IIIII:BOOLEAN;VARIABLE IOO000O0Ol1OlIOOI00l11I1l1I00IIIII:BOOLEAN;VARIABLE IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:BOOLEAN;VARIABLE IIOI10lI0II00O0IOOl0I10001lO1IIIII:BOOLEAN;VARIABLE IIO1IIOOO0OO1100OO11l0OOllIIIOIIII:BOOLEAN;BEGIN
 IIlIIII1lOllO0IlO11I1O01110IOIIIII:='0';II0I1I1l00l1O11OOIOIIllII10IlIIIII:='0';III0lIIOOIOl0ll0ll0l1lO10IlIIIIIII:='0';IO0I10OO0llIIlII1I01OOI001IIIIIIII:=CONV_INTEGER(IOl00OIO0IOOllO1I1O101lIIl11OIIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII-1));II110IlI0l101IO1IlI1O00llI00OIIIII:=CONV_INTEGER(IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII-1));IF IIO0101IlI11I0IOlI01l1ll0O10OIIIII THEN II110IlI0l101IO1IlI1O00llI00OIIIII
:=1-II110IlI0l101IO1IlI1O00llI00OIIIII;END IF;IOOI10l11llO01llIIllOI1IO0l1OIIIII:=FLT_PT_IS_INF(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,IOl00OIO0IOOllO1I1O101lIIl11OIIIII);IOO1IIll11IlI110IOlllI1Il1IO1IIIII:=FLT_PT_IS_NAN(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,IOl00OIO0IOOllO1I1O101lIIl11OIIIII);IOO000O0Ol1OlIOOI00l11I1l1I00IIIII:=II1IOOO1II0l1lOl00I1O001I00O0IIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,IOl00OIO0IOOllO1I1O101lIIl11OIIIII);IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:=
FLT_PT_IS_INF(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII);IIOI10lI0II00O0IOOl0I10001lO1IIIII:=FLT_PT_IS_NAN(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII);IIO1IIOOO0OO1100OO11l0OOllIIIOIIII:=II1IOOO1II0l1lOl00I1O001I00O0IIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII);IF IOO1IIll11IlI110IOlllI1Il1IO1IIIII OR IIOI10lI0II00O0IOOl0I10001lO1IIIII THEN IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:=
FLT_PT_GET_QUIET_NAN(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII);ELSIF IOOI10l11llO01llIIllOI1IO0l1OIIIII AND IIll0O11l1O1lOl111IIOlOIl0I0OIIIII THEN IF IO0I10OO0llIIlII1I01OOI001IIIIIIII=II110IlI0l101IO1IlI1O00llI00OIIIII THEN IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:=FLT_PT_GET_INF(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,CONV_STD_LOGIC_VECTOR(
IO0I10OO0llIIlII1I01OOI001IIIIIIII,1)(0));ELSE IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:=FLT_PT_GET_QUIET_NAN(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII);IIlIIII1lOllO0IlO11I1O01110IOIIIII:='1';END IF;ELSIF IOOI10l11llO01llIIllOI1IO0l1OIIIII THEN IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:=FLT_PT_GET_INF(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,
CONV_STD_LOGIC_VECTOR(IO0I10OO0llIIlII1I01OOI001IIIIIIII,1)(0));ELSIF IIll0O11l1O1lOl111IIOlOIl0I0OIIIII THEN IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:=FLT_PT_GET_INF(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,CONV_STD_LOGIC_VECTOR(II110IlI0l101IO1IlI1O00llI00OIIIII,1)(0));ELSIF IOO000O0Ol1OlIOOI00l11I1l1I00IIIII
 AND IIO1IIOOO0OO1100OO11l0OOllIIIOIIII THEN IF(IO0I10OO0llIIlII1I01OOI001IIIIIIII+II110IlI0l101IO1IlI1O00llI00OIIIII)=2 THEN II1llIOlOlll00O010O1lI1IOI1I1IIIII:='1';ELSE II1llIOlOlll00O010O1lI1IOI1I1IIIII:='0';END IF;IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:=FLT_PT_GET_ZERO(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,II1llIOlOlll00O010O1lI1IOI1I1IIIII);ELSIF IOO000O0Ol1OlIOOI00l11I1l1I00IIIII
 THEN IF II110IlI0l101IO1IlI1O00llI00OIIIII=1 THEN IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:='1'&IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII-2 DOWNTO 0);ELSE IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:='0'&IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII-2 DOWNTO 0);END IF;ELSIF IIO1IIOOO0OO1100OO11l0OOllIIIOIIII THEN IF IO0I10OO0llIIlII1I01OOI001IIIIIIII=1 THEN
 IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:='1'&IOl00OIO0IOOllO1I1O101lIIl11OIIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII-2 DOWNTO 0);ELSE IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:='0'&IOl00OIO0IOOllO1I1O101lIIl11OIIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII-2 DOWNTO 0);END IF;ELSE III010I1Ol1OlOI0IO10O0000II11IIIII:=(OTHERS=>'0');III010I1Ol1OlOI0IO10O0000II11IIIII(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII):='1';III010I1Ol1OlOI0IO10O0000II11IIIII(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII-1
 DOWNTO IOO0llOIlIO0110l1lOO01I00l1OIIIIII+1):=SIGNED(IOl00OIO0IOOllO1I1O101lIIl11OIIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII-2 DOWNTO 0));IIO111Il00001lO0l00lOOlI1IO10IIIII:=CONV_INTEGER(UNSIGNED(IOl00OIO0IOOllO1I1O101lIIl11OIIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII-2 DOWNTO IOO0llOIlIO0110l1lOO01I00l1OIIIIII-1)));IIO111Il00001lO0l00lOOlI1IO10IIIII:=IIO111Il00001lO0l00lOOlI1IO10IIIII-IO0lI0OlO11O10O1III000O01l0l0IIIII;IOIlOO00I1I00lO00l0I00OlIO01IIIIII:=(OTHERS
=>'0');IOIlOO00I1I00lO00l0I00OlIO01IIIIII(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII):='1';IOIlOO00I1I00lO00l0I00OlIO01IIIIII(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII-1 DOWNTO IOO0llOIlIO0110l1lOO01I00l1OIIIIII+1):=SIGNED(IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII-2 DOWNTO 0));II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:=CONV_INTEGER(UNSIGNED(IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII-2 DOWNTO IOO0llOIlIO0110l1lOO01I00l1OIIIIII-1)));
II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII-IO0lI0OlO11O10O1III000O01l0l0IIIII;IF IIO111Il00001lO0l00lOOlI1IO10IIIII>II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII THEN IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII:=IIO111Il00001lO0l00lOOlI1IO10IIIII-II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII;IO1I11OIllI1III1III11OlIIlIIOIIIII:=IIO111Il00001lO0l00lOOlI1IO10IIIII;IOIlOO00I1I00lO00l0I00OlIO01IIIIII:=SHR(IOIlOO00I1I00lO00l0I00OlIO01IIIIII,CONV_UNSIGNED(IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII,IOIO0OOIOIOl0OIllO011O11O0OOIIIIII+1));ELSE
 IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII-IIO111Il00001lO0l00lOOlI1IO10IIIII;IO1I11OIllI1III1III11OlIIlIIOIIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII;III010I1Ol1OlOI0IO10O0000II11IIIII:=SHR(III010I1Ol1OlOI0IO10O0000II11IIIII,CONV_UNSIGNED(IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII,IOIO0OOIOIOl0OIllO011O11O0OOIIIIII+1));END IF;IF IO0I10OO0llIIlII1I01OOI001IIIIIIII=0 THEN IF II110IlI0l101IO1IlI1O00llI00OIIIII=0 THEN III0O000IO1IOIO10l0I00lOIII11IIIII
:=III010I1Ol1OlOI0IO10O0000II11IIIII+IOIlOO00I1I00lO00l0I00OlIO01IIIIII;ELSE III0O000IO1IOIO10l0I00lOIII11IIIII:=III010I1Ol1OlOI0IO10O0000II11IIIII-IOIlOO00I1I00lO00l0I00OlIO01IIIIII;END IF;ELSE IF II110IlI0l101IO1IlI1O00llI00OIIIII=0 THEN III0O000IO1IOIO10l0I00lOIII11IIIII:=IOIlOO00I1I00lO00l0I00OlIO01IIIIII-III010I1Ol1OlOI0IO10O0000II11IIIII;ELSE III0O000IO1IOIO10l0I00lOIII11IIIII:=-(III010I1Ol1OlOI0IO10O0000II11IIIII+IOIlOO00I1I00lO00l0I00OlIO01IIIIII);END IF;END IF
;IF III0O000IO1IOIO10l0I00lOIII11IIIII(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII+2)='1'THEN III0O000IO1IOIO10l0I00lOIII11IIIII:=ABS(III0O000IO1IOIO10l0I00lOIII11IIIII);II1llIOlOlll00O010O1lI1IOI1I1IIIII:='1';ELSE II1llIOlOlll00O010O1lI1IOI1I1IIIII:='0';END IF;IF III0O000IO1IOIO10l0I00lOIII11IIIII(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII+1)='1'THEN III0O000IO1IOIO10l0I00lOIII11IIIII:=SHR(
III0O000IO1IOIO10l0I00lOIII11IIIII,CONV_UNSIGNED(1,1));IO1I11OIllI1III1III11OlIIlIIOIIIII:=IO1I11OIllI1III1III11OlIIlIIOIIIII+1;ELSE IIl11lIlOO0IIII0IOlI0l1000I1IIIIII:=0;WHILE IIl11lIlOO0IIII0IOlI0l1000I1IIIIII<2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII AND III0O000IO1IOIO10l0I00lOIII11IIIII(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII)='0'LOOP III0O000IO1IOIO10l0I00lOIII11IIIII:=SHL(
III0O000IO1IOIO10l0I00lOIII11IIIII,CONV_UNSIGNED(1,1));IIl11lIlOO0IIII0IOlI0l1000I1IIIIII:=IIl11lIlOO0IIII0IOlI0l1000I1IIIIII+1;END LOOP;IO1I11OIllI1III1III11OlIIlIIOIIIII:=IO1I11OIllI1III1III11OlIIlIIOIIIII-IIl11lIlOO0IIII0IOlI0l1000I1IIIIII;END IF;IF III0O000IO1IOIO10l0I00lOIII11IIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII)='0'THEN ELSIF
 III0O000IO1IOIO10l0I00lOIII11IIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII DOWNTO 0)=IO01O100lOO0IOOI000OO1lIOO1l0IIIII THEN IF III0O000IO1IOIO10l0I00lOIII11IIIII(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+1)='1'THEN III0O000IO1IOIO10l0I00lOIII11IIIII:=III0O000IO1IOIO10l0I00lOIII11IIIII+IIOIlOO1lI01O10O1Ol0OOI10110OIIIII;ELSE END IF;ELSE III0O000IO1IOIO10l0I00lOIII11IIIII:=III0O000IO1IOIO10l0I00lOIII11IIIII+IIOIlOO1lI01O10O1Ol0OOI10110OIIIII;
END IF;IF III0O000IO1IOIO10l0I00lOIII11IIIII(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII+1)='1'THEN III0O000IO1IOIO10l0I00lOIII11IIIII:=SHR(III0O000IO1IOIO10l0I00lOIII11IIIII,CONV_UNSIGNED(1,1));IO1I11OIllI1III1III11OlIIlIIOIIIII:=IO1I11OIllI1III1III11OlIIlIIOIIIII+1;END IF;IF III0O000IO1IOIO10l0I00lOIII11IIIII=IO0II1lll1llOlO1lll1001O1IlOIOIIII THEN IOOO00lOlO0l0llI01lIlOOIIllIlIIIII
:=FLT_PT_GET_ZERO(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,'0');ELSIF IO1I11OIllI1III1III11OlIIlIIOIIIII<IIO1O00llO01OII1I11lIIO001lI0IIIII THEN IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:=FLT_PT_GET_ZERO(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,II1llIOlOlll00O010O1lI1IOI1I1IIIII);III0lIIOOIOl0ll0ll0l1lO10IlIIIIIII:='1';ELSIF IO1I11OIllI1III1III11OlIIlIIOIIIII
>IOIl1lI1IO111IO0OII101O1I0l0IOIIII THEN IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:=FLT_PT_GET_INF(IOO0llOIlIO0110l1lOO01I00l1OIIIIII+IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IOO0llOIlIO0110l1lOO01I00l1OIIIIII,II1llIOlOlll00O010O1lI1IOI1I1IIIII);II0I1I1l00l1O11OOIOIIllII10IlIIIII:='1';ELSE IO1I11OIllI1III1III11OlIIlIIOIIIII:=IO1I11OIllI1III1III11OlIIlIIOIIIII+IO0lI0OlO11O10O1III000O01l0l0IIIII;IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:=II1llIOlOlll00O010O1lI1IOI1I1IIIII&
CONV_STD_LOGIC_VECTOR(IO1I11OIllI1III1III11OlIIlIIOIIIII,IOIO0OOIOIOl0OIllO011O11O0OOIIIIII)&CONV_STD_LOGIC_VECTOR(III0O000IO1IOIO10l0I00lOIII11IIIII(2*IOO0llOIlIO0110l1lOO01I00l1OIIIIII-1 DOWNTO IOO0llOIlIO0110l1lOO01I00l1OIIIIII+1),IOO0llOIlIO0110l1lOO01I00l1OIIIIII-1);END IF;END IF;IO00OI0ll1l1l0llI1I000OOO0010IIIII:=IOOO00lOlO0l0llI01lIlOOIIllIlIIIII;IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII:=
IIlIIII1lOllO0IlO11I1O01110IOIIIII;IOI0111Il0IllIIO0O0lO0I111010IIIII:=II0I1I1l00l1O11OOIOIIllII10IlIIIII;IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII:=III0lIIOOIOl0ll0ll0l1lO10IlIIIIIII;END;PROCEDURE IOO01O011lIIIlOl1O0lOIOOI110IOIIII(IOIOO101OO01Ol1101l1O01O1OOllIIIII:IN INTEGER;IIOO0IIlO0O0I01l00I1011II0011IIIII:IN INTEGER;IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII:IN INTEGER
;IIOlI0O00IO011lIIOl100O001lIOOIIII:IN INTEGER;III0IlIOll1Ill0I0I0OlIO10I1I1IIIII:IN STD_LOGIC_VECTOR;IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII:OUT STD_LOGIC_VECTOR;II0I1O11OOll0l0I11O110OlI0lIOOIIII:OUT STD_LOGIC;II1lI1l0l00llI0l0l1O0OOII10I1IIIII:OUT STD_LOGIC;II0l10llII1lO0O1lOIlOOI10I0lIIIIII:OUT
 STD_LOGIC)IS CONSTANT IO1I1OlOI1OII110llI1lI0IIl0O0IIIII:INTEGER:=IOIOO101OO01Ol1101l1O01O1OOllIIIII-IIOO0IIlO0O0I01l00I1011II0011IIIII;CONSTANT II110IO0lllI1lOI110IO00I1lOlIIIIII:INTEGER:=IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII-IIOlI0O00IO011lIIOl100O001lIOOIIII;CONSTANT IIl110lllO10l0llOI11l01I0I1OlIIIII:INTEGER:=2**(IO1I1OlOI1OII110llI1lI0IIl0O0IIIII-1)-
1;CONSTANT IOOll11IO1O1llOIl10010O1IIOOIIIIII:INTEGER:=2**(II110IO0lllI1lOI110IO00I1lOlIIIIII-1)-1;CONSTANT IIII00I101O111lII1O000IO1lOOIIIIII:INTEGER:=2-2**(II110IO0lllI1lOI110IO00I1lOlIIIIII-1);CONSTANT IOOI01II11O1I1IOII1II01O1001lIIIII:INTEGER:=2**(
II110IO0lllI1lOI110IO00I1lOlIIIIII-1)-1;CONSTANT IO111Il1I1O0lO1OlOI0l01I1O010IIIII:UNSIGNED(IIOO0IIlO0O0I01l00I1011II0011IIIII-1 DOWNTO 0):=(OTHERS=>'0');VARIABLE III011IIIl1IO1l0O11000I0llI00IIIII:STD_LOGIC;VARIABLE II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:
STD_LOGIC;VARIABLE IIO1l1Ol1l11Il0000II00lI011I0IIIII:STD_LOGIC;VARIABLE IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII:BOOLEAN;VARIABLE II1lI11lI1II1000lOllIOl01l0l0IIIII:BOOLEAN;VARIABLE II0l0001lI0I0IlllI1I100OO10IIIIIII:BOOLEAN;VARIABLE
 II01l0llO10l10II111lIlOIllO0lIIIII:UNSIGNED(IIOO0IIlO0O0I01l00I1011II0011IIIII DOWNTO 0);VARIABLE IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII:INTEGER;VARIABLE IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:STD_LOGIC;VARIABLE IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:BOOLEAN;VARIABLE II10l111IOllO0O1111Ill001lll1IIIII:INTEGER;
VARIABLE IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:UNSIGNED(IIOlI0O00IO011lIIOl100O001lIOOIIII DOWNTO 0);VARIABLE IIll1lO0l0lI0OII00l00OO11IlO1IIIII:BOOLEAN:=FALSE;VARIABLE III00O11l11IlIOI1llIIIOII100lIIIII:STD_LOGIC_VECTOR(IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII-1 DOWNTO 0);
BEGIN III011IIIl1IO1l0O11000I0llI00IIIII:='0';II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:='0';IIO1l1Ol1l11Il0000II00lI011I0IIIII:='0';IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=III0IlIOll1Ill0I0I0OlIO10I1I1IIIII(IOIOO101OO01Ol1101l1O01O1OOllIIIII-1);IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII:=FLT_PT_IS_INF(IOIOO101OO01Ol1101l1O01O1OOllIIIII,IIOO0IIlO0O0I01l00I1011II0011IIIII,III0IlIOll1Ill0I0I0OlIO10I1I1IIIII);II1lI11lI1II1000lOllIOl01l0l0IIIII:=FLT_PT_IS_NAN
(IOIOO101OO01Ol1101l1O01O1OOllIIIII,IIOO0IIlO0O0I01l00I1011II0011IIIII,III0IlIOll1Ill0I0I0OlIO10I1I1IIIII);II0l0001lI0I0IlllI1I100OO10IIIIIII:=II1IOOO1II0l1lOl00I1O001I00O0IIIII(IOIOO101OO01Ol1101l1O01O1OOllIIIII,IIOO0IIlO0O0I01l00I1011II0011IIIII,III0IlIOll1Ill0I0I0OlIO10I1I1IIIII);IF II1lI11lI1II1000lOllIOl01l0l0IIIII THEN III00O11l11IlIOI1llIIIOII100lIIIII:=FLT_PT_GET_QUIET_NAN(IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII,IIOlI0O00IO011lIIOl100O001lIOOIIII);ELSIF
 IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII THEN III00O11l11IlIOI1llIIIOII100lIIIII:=FLT_PT_GET_INF(IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII,IIOlI0O00IO011lIIOl100O001lIOOIIII,CONV_STD_LOGIC_VECTOR(IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII,1)(0));ELSIF II0l0001lI0I0IlllI1I100OO10IIIIIII THEN III00O11l11IlIOI1llIIIOII100lIIIII:=
FLT_PT_GET_ZERO(IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII,IIOlI0O00IO011lIIOl100O001lIOOIIII,IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII);ELSIF IIOlI0O00IO011lIIOl100O001lIOOIIII=IIOO0IIlO0O0I01l00I1011II0011IIIII AND IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII=IOIOO101OO01Ol1101l1O01O1OOllIIIII THEN III00O11l11IlIOI1llIIIOII100lIIIII:=III0IlIOll1Ill0I0I0OlIO10I1I1IIIII;ELSE II01l0llO10l10II111lIlOIllO0lIIIII:=UNSIGNED("01"&III0IlIOll1Ill0I0I0OlIO10I1I1IIIII(IIOO0IIlO0O0I01l00I1011II0011IIIII-2
 DOWNTO 0));IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII:=CONV_INTEGER(UNSIGNED(III0IlIOll1Ill0I0I0OlIO10I1I1IIIII(IOIOO101OO01Ol1101l1O01O1OOllIIIII-2 DOWNTO IIOO0IIlO0O0I01l00I1011II0011IIIII-1)));IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII:=IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII-IIl110lllO10l0llOI11l01I0I1OlIIIII;IF IIOO0IIlO0O0I01l00I1011II0011IIIII<IIOlI0O00IO011lIIOl100O001lIOOIIII THEN IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII(IIOlI0O00IO011lIIOl100O001lIOOIIII
 DOWNTO IIOlI0O00IO011lIIOl100O001lIOOIIII-IIOO0IIlO0O0I01l00I1011II0011IIIII):=II01l0llO10l10II111lIlOIllO0lIIIII(IIOO0IIlO0O0I01l00I1011II0011IIIII DOWNTO 0);IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII(IIOlI0O00IO011lIIOl100O001lIOOIIII-IIOO0IIlO0O0I01l00I1011II0011IIIII-1 DOWNTO 0):=(OTHERS=>'0');II10l111IOllO0O1111Ill001lll1IIIII:=IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII;ELSE IF IIOO0IIlO0O0I01l00I1011II0011IIIII-
IIOlI0O00IO011lIIOl100O001lIOOIIII>1 THEN IIll1lO0l0lI0OII00l00OO11IlO1IIIII:=II01l0llO10l10II111lIlOIllO0lIIIII(IIOO0IIlO0O0I01l00I1011II0011IIIII-IIOlI0O00IO011lIIOl100O001lIOOIIII-2 DOWNTO 0)=IO111Il1I1O0lO1OlOI0l01I1O010IIIII(IIOO0IIlO0O0I01l00I1011II0011IIIII-IIOlI0O00IO011lIIOl100O001lIOOIIII-2 DOWNTO 0);ELSE IIll1lO0l0lI0OII00l00OO11IlO1IIIII:=TRUE;END IF;IF IIOO0IIlO0O0I01l00I1011II0011IIIII-
IIOlI0O00IO011lIIOl100O001lIOOIIII>0 THEN IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:=(II01l0llO10l10II111lIlOIllO0lIIIII(IIOO0IIlO0O0I01l00I1011II0011IIIII-IIOlI0O00IO011lIIOl100O001lIOOIIII-1)='1')AND(NOT(IIll1lO0l0lI0OII00l00OO11IlO1IIIII)OR(IIll1lO0l0lI0OII00l00OO11IlO1IIIII AND(II01l0llO10l10II111lIlOIllO0lIIIII(IIOO0IIlO0O0I01l00I1011II0011IIIII-IIOlI0O00IO011lIIOl100O001lIOOIIII)='1')));IF IIl1O01ll1111l0llIOO0OOl1ll0IOIIII THEN
 IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:=II01l0llO10l10II111lIlOIllO0lIIIII(IIOO0IIlO0O0I01l00I1011II0011IIIII DOWNTO IIOO0IIlO0O0I01l00I1011II0011IIIII-IIOlI0O00IO011lIIOl100O001lIOOIIII)+1;ELSE IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:=II01l0llO10l10II111lIlOIllO0lIIIII(IIOO0IIlO0O0I01l00I1011II0011IIIII DOWNTO IIOO0IIlO0O0I01l00I1011II0011IIIII-IIOlI0O00IO011lIIOl100O001lIOOIIII);END IF;IF IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII(IIOlI0O00IO011lIIOl100O001lIOOIIII)='1'
THEN II10l111IOllO0O1111Ill001lll1IIIII:=IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII+1;ELSE II10l111IOllO0O1111Ill001lll1IIIII:=IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII;END IF;ELSE II10l111IOllO0O1111Ill001lll1IIIII:=IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII;IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:=II01l0llO10l10II111lIlOIllO0lIIIII;END IF;END IF;IF II10l111IOllO0O1111Ill001lll1IIIII<IIII00I101O111lII1O000IO1lOOIIIIII THEN
 III00O11l11IlIOI1llIIIOII100lIIIII:=FLT_PT_GET_ZERO(IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII,IIOlI0O00IO011lIIOl100O001lIOOIIII,IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII);IIO1l1Ol1l11Il0000II00lI011I0IIIII:='1';ELSIF II10l111IOllO0O1111Ill001lll1IIIII>IOOI01II11O1I1IOII1II01O1001lIIIII THEN III00O11l11IlIOI1llIIIOII100lIIIII:=FLT_PT_GET_INF(IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII,
IIOlI0O00IO011lIIOl100O001lIOOIIII,IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII);II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:='1';ELSE II10l111IOllO0O1111Ill001lll1IIIII:=II10l111IOllO0O1111Ill001lll1IIIII+IOOll11IO1O1llOIl10010O1IIOOIIIIII;III00O11l11IlIOI1llIIIOII100lIIIII:=IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII&CONV_STD_LOGIC_VECTOR(II10l111IOllO0O1111Ill001lll1IIIII,II110IO0lllI1lOI110IO00I1lOlIIIIII)&
STD_LOGIC_VECTOR(IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII(IIOlI0O00IO011lIIOl100O001lIOOIIII-2 DOWNTO 0));END IF;END IF;IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII:=III00O11l11IlIOI1llIIIOII100lIIIII;II0I1O11OOll0l0I11O110OlI0lIOOIIII:=III011IIIl1IO1l0O11000I0llI00IIIII;II1lI1l0l00llI0l0l1O0OOII10I1IIIII:=II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII;II0l10llII1lO0O1lOIlOOI10I0lIIIIII:=
IIO1l1Ol1l11Il0000II00lI011I0IIIII;END;PROCEDURE IO1l01O110OIl00l10lOOlI0lI0I0IIIII(IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:IN INTEGER;IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:IN INTEGER;IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:IN INTEGER;III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:IN INTEGER;IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:IN
 STD_LOGIC_VECTOR;IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:IN STD_LOGIC_VECTOR(FLT_PT_ROUND_MODE_WIDTH-1 DOWNTO 0);III11I01Ol11IOO00IOI1I11OOl10IIIII:OUT STD_LOGIC_VECTOR;IIl1lOIllIlIl01ll00O11OIl100IOIIII:OUT STD_LOGIC
;IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII:OUT STD_LOGIC;II1011l1lI11IlIlI0l0l00100lO0IIIII:OUT STD_LOGIC)IS CONSTANT IO1OO10IOIO11O10IOOOllllI1Il0IIIII:BOOLEAN:=TRUE;CONSTANT II1IOl1011OlI0O00l1O10OlllOI0IIIII:INTEGER:=2**(IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII-IOIIOO1001lI01IOOlOllIOOIO1O1IIIII-1
)-1;CONSTANT IO1OIOllI1llI01O00IIl0O111IIOOIIII:SIGNED(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-1 DOWNTO 0):=(OTHERS=>'0');CONSTANT IO01001lO000lI1lI0IO11lO0I1OlIIIII:SIGNED(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-1 DOWNTO 0):=(OTHERS=>'1');CONSTANT
 IOOl11OIOl101I1I1I00lIlIlO00IIIIII:SIGNED(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-1 DOWNTO 0):='1'&IO1OIOllI1llI01O00IIl0O111IIOOIIII(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-2 DOWNTO 0);CONSTANT IIlOOO01III1O0O0IOII0I0lOlIlOIIIII:SIGNED(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-1 DOWNTO 0):='0'&
IO01001lO000lI1lI0IO11lO0I1OlIIIII(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-2 DOWNTO 0);CONSTANT IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII:SIGNED(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII-1 DOWNTO 0):=(OTHERS=>'0');CONSTANT IIl010l00OlI0lO1OO11Il10lIOIOOIIII:SIGNED(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII DOWNTO 0):=
'1'&IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII;CONSTANT IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII:SIGNED(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII DOWNTO 0):=(OTHERS=>'0');CONSTANT IIl111Il0IIlOIO000I01l00l0111IIIII:SIGNED(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII-1 DOWNTO 0):=(
OTHERS=>'0');CONSTANT II1111O0III10O0OOlOlOO1l1I1l0IIIII:SIGNED(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII+IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+1 DOWNTO 0):=IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII&'1'&IIl111Il0IIlOIO000I01l00l0111IIIII;VARIABLE III00011101l1O1OOI0l0Il0l1l10IIIII:SIGNED(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-1
 DOWNTO 0);VARIABLE IO0lll11llOIOOIOI1lOOIOl000I0IIIII:STD_LOGIC;VARIABLE IO00OO00lIlIO00llOIll10l0ll1OIIIII:STD_LOGIC;VARIABLE IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:SIGNED(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+IIOlIO1l10OOO1l1IlII1ll0100IOIIIII+1 DOWNTO 0);VARIABLE II1001l0I11O0IIOIl01I1ll0O0OlIIIII:
INTEGER;VARIABLE II1II1OO1ll10IlO0I10O0OI000IIOIIII:INTEGER;VARIABLE IOOl01OO110II1I0lIlI001II11I0IIIII:INTEGER;VARIABLE II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII:INTEGER;CONSTANT IIll0I0ll1ll1O0IOlO1O01llII00IIIII:SIGNED(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII-1 DOWNTO 0):=(
OTHERS=>'0');BEGIN IO0lll11llOIOOIOI1lOOIOl000I0IIIII:='0';IO00OO00lIlIO00llOIll10l0ll1OIIIII:='0';IOOl01OO110II1I0lIlI001II11I0IIIII:=CONV_INTEGER(IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII(IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII-1));IF II1IOOO1II0l1lOl00I1O001I00O0IIIII(IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII,IOIIOO1001lI01IOOlOllIOOIO1O1IIIII,IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII)THEN III00011101l1O1OOI0l0Il0l1l10IIIII:=
IO1OIOllI1llI01O00IIl0O111IIOOIIII;ELSIF FLT_PT_IS_NAN(IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII,IOIIOO1001lI01IOOlOllIOOIO1O1IIIII,IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII)THEN III00011101l1O1OOI0l0Il0l1l10IIIII:=IOOl11OIOl101I1I1I00lIlIlO00IIIIII;IO0lll11llOIOOIOI1lOOIOl000I0IIIII:='1';ELSIF FLT_PT_IS_INF(IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII,IOIIOO1001lI01IOOlOllIOOIO1O1IIIII,IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII)THEN IF IOOl01OO110II1I0lIlI001II11I0IIIII=0 THEN
 III00011101l1O1OOI0l0Il0l1l10IIIII:=IIlOOO01III1O0O0IOII0I0lOlIlOIIIII;ELSE III00011101l1O1OOI0l0Il0l1l10IIIII:=IOOl11OIOl101I1I1I00lIlIlO00IIIIII;END IF;IO00OO00lIlIO00llOIll10l0ll1OIIIII:='1';IO0lll11llOIOOIOI1lOOIOl000I0IIIII:='1';ELSE IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:=(OTHERS=>'0');IIO1lO000Il1O0lOII1IO0OOOIO00IIIII(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+IIOlIO1l10OOO1l1IlII1ll0100IOIIIII):='1';
IIO1lO000Il1O0lOII1IO0OOOIO00IIIII(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-1 DOWNTO IIOlIO1l10OOO1l1IlII1ll0100IOIIIII+1):=SIGNED(IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII-2 DOWNTO 0));II1001l0I11O0IIOIl01I1ll0O0OlIIIII:=CONV_INTEGER(UNSIGNED(IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII(IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII-2 DOWNTO IOIIOO1001lI01IOOlOllIOOIO1O1IIIII-1)));II1001l0I11O0IIOIl01I1ll0O0OlIIIII:=
II1001l0I11O0IIOIl01I1ll0O0OlIIIII-II1IOl1011OlI0O00l1O10OlllOI0IIIII;II1II1OO1ll10IlO0I10O0OI000IIOIIII:=(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-(III1I01Ill1l0lOIlO01lO0I1IlIIOIIII+1))-II1001l0I11O0IIOIl01I1ll0O0OlIIIII;IF II1II1OO1ll10IlO0I10O0OI000IIOIIII>0 OR(II1II1OO1ll10IlO0I10O0OI000IIOIIII=0 AND IIO1lO000Il1O0lOII1IO0OOOIO00IIIII(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-1 DOWNTO IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+1)=
IIll0I0ll1ll1O0IOlO1O01llII00IIIII)THEN IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:=SHR(IIO1lO000Il1O0lOII1IO0OOOIO00IIIII,CONV_UNSIGNED(II1II1OO1ll10IlO0I10O0OI000IIOIIII,IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII-IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+1));ELSE IO00OO00lIlIO00llOIll10l0ll1OIIIII:='1';END IF;IF IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII=
FLT_PT_RND_TO_NEAREST_EVEN_SLV THEN IF(IIO1lO000Il1O0lOII1IO0OOOIO00IIIII(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII)='0')THEN ELSIF IIO1lO000Il1O0lOII1IO0OOOIO00IIIII(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII DOWNTO 0)=IIl010l00OlI0lO1OO11Il10lIOIOOIIII THEN IF(IIO1lO000Il1O0lOII1IO0OOOIO00IIIII(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+1)='1')THEN
 IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:=IIO1lO000Il1O0lOII1IO0OOOIO00IIIII+II1111O0III10O0OOlOlOO1l1I1l0IIIII;ELSE END IF;ELSE IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:=IIO1lO000Il1O0lOII1IO0OOOIO00IIIII+II1111O0III10O0OOlOlOO1l1I1l0IIIII;END IF;END IF;IF IOOl01OO110II1I0lIlI001II11I0IIIII=1 THEN IIO1lO000Il1O0lOII1IO0OOOIO00IIIII(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII+IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+1 DOWNTO IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+1):=-
IIO1lO000Il1O0lOII1IO0OOOIO00IIIII(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII+IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+1 DOWNTO IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+1);END IF;IF(IIO1lO000Il1O0lOII1IO0OOOIO00IIIII(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+1+IIOlIO1l10OOO1l1IlII1ll0100IOIIIII)XOR IIO1lO000Il1O0lOII1IO0OOOIO00IIIII(IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+IIOlIO1l10OOO1l1IlII1ll0100IOIIIII))='1'THEN IO00OO00lIlIO00llOIll10l0ll1OIIIII:='1';END IF;IF
 IO0lll11llOIOOIOI1lOOIOl000I0IIIII='1'OR IO00OO00lIlIO00llOIll10l0ll1OIIIII='1'THEN IF IOOl01OO110II1I0lIlI001II11I0IIIII=0 THEN III00011101l1O1OOI0l0Il0l1l10IIIII:=IIlOOO01III1O0O0IOII0I0lOlIlOIIIII;ELSE III00011101l1O1OOI0l0Il0l1l10IIIII:=IOOl11OIOl101I1I1I00lIlIlO00IIIIII;END IF;ELSE III00011101l1O1OOI0l0Il0l1l10IIIII:=IIO1lO000Il1O0lOII1IO0OOOIO00IIIII(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII+IOIIOO1001lI01IOOlOllIOOIO1O1IIIII
 DOWNTO IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+1);END IF;END IF;III11I01Ol11IOO00IOI1I11OOl10IIIII:=STD_LOGIC_VECTOR(III00011101l1O1OOI0l0Il0l1l10IIIII);IF NOT(IO1OO10IOIO11O10IOOOllllI1Il0IIIII)THEN IIl1lOIllIlIl01ll00O11OIl100IOIIII:=IO0lll11llOIOOIOI1lOOIOl000I0IIIII OR IO00OO00lIlIO00llOIll10l0ll1OIIIII;IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII:='0';
ELSE IIl1lOIllIlIl01ll00O11OIl100IOIIII:=IO0lll11llOIOOIOI1lOOIOl000I0IIIII;IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII:=IO00OO00lIlIO00llOIll10l0ll1OIIIII;END IF;II1011l1lI11IlIlI0l0l00100lO0IIIII:='0';END;PROCEDURE II1ll1Il1Il11O10OllIl0l1l1l0IOIIII(III0II00l1IIlIO100l00OlI1l1O0IIIII:IN INTEGER;II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:IN INTEGER;
IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII:IN INTEGER;III101l00lllOOOlIO0OO1lI1OO1OIIIII:IN INTEGER;II0l0l0II0Il010II1l000011O1lIIIIII:IN STD_LOGIC_VECTOR;IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII:OUT STD_LOGIC_VECTOR;IOO0lOOOll1OI0OI0lI10IOOOII00IIIII:OUT STD_LOGIC;II111O1llOOlI0lOOIIIl0OIlIlllIIIII:OUT
 STD_LOGIC;IIO11lIl110IO0lO00IOOl0Il11I1IIIII:OUT STD_LOGIC)IS CONSTANT II1IO0OO0IOlO11110OOlO1O0101IOIIII:INTEGER:=IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII-III101l00lllOOOlIO0OO1lI1OO1OIIIII;CONSTANT II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII:INTEGER:=2**(II1IO0OO0IOlO11110OOlO1O0101IOIIII-1)-1;CONSTANT
 IO0OIl1OO10lO00IlIl0Il0l1l1OIIIIII:INTEGER:=0;CONSTANT IO0lllOII000O01100OOI0II1II01IIIII:INTEGER:=2**II1IO0OO0IOlO11110OOlO1O0101IOIIII-1;CONSTANT IO0IllIIO11IlI1010IIl0l000001IIIII:INTEGER:=FLT_PT_MAX(III0II00l1IIlIO100l00OlI1l1O0IIIII+1,III101l00lllOOOlIO0OO1lI1OO1OIIIII+1);CONSTANT II1l0I0l10l0I1I1lO01l10I01lI1IIIII:
SIGNED(IO0IllIIO11IlI1010IIl0l000001IIIII-1 DOWNTO 0):=(OTHERS=>'0');VARIABLE IIO001lIl0II1lI10I1000O00Ol10IIIII:INTEGER;VARIABLE IIOI1lO0I00III00II0IO0ll0111IOIIII:SIGNED(IO0IllIIO11IlI1010IIl0l000001IIIII-1 DOWNTO 0);VARIABLE III11OII1IlIl1001I1IO1111l0IlIIIII:
STD_LOGIC_VECTOR(IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII-1 DOWNTO 0);VARIABLE IIII11lI1lOl0OlOO0II11lI101lOIIIII:STD_LOGIC;VARIABLE IOl0Ill1OOl0O1IO1l0010I0lO010IIIII:STD_LOGIC;VARIABLE IO0IlOI1OIOO0l101l10IO00l0101IIIII:STD_LOGIC;
VARIABLE IIOO1OlIO01I00l0OO0I11OII1OlOIIIII:SIGNED(IO0IllIIO11IlI1010IIl0l000001IIIII-1 DOWNTO 0);VARIABLE IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII:INTEGER;VARIABLE IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII:STD_LOGIC;VARIABLE IIl1O1IllII0I01IlO01l0lII0lIOOIIII:INTEGER;VARIABLE IOI1IOl0OI0O1OllO10lO1lOOl0l1IIIII:
BOOLEAN;BEGIN IIII11lI1lOl0OlOO0II11lI101lOIIIII:='0';IOl0Ill1OOl0O1IO1l0010I0lO010IIIII:='0';IO0IlOI1OIOO0l101l10IO00l0101IIIII:='0';IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII:=II0l0l0II0Il010II1l000011O1lIIIIII(III0II00l1IIlIO100l00OlI1l1O0IIIII-1);IIOO1OlIO01I00l0OO0I11OII1OlOIIIII:=(OTHERS=>'0');IIOO1OlIO01I00l0OO0I11OII1OlOIIIII(IO0IllIIO11IlI1010IIl0l000001IIIII-1 DOWNTO IO0IllIIO11IlI1010IIl0l000001IIIII-III0II00l1IIlIO100l00OlI1l1O0IIIII-1):=
SIGNED(SXT(II0l0l0II0Il010II1l000011O1lIIIIII,III0II00l1IIlIO100l00OlI1l1O0IIIII+1));IF IO0IllIIO11IlI1010IIl0l000001IIIII>(III0II00l1IIlIO100l00OlI1l1O0IIIII+1)THEN IIOO1OlIO01I00l0OO0I11OII1OlOIIIII(IO0IllIIO11IlI1010IIl0l000001IIIII-III0II00l1IIlIO100l00OlI1l1O0IIIII-2 DOWNTO 0):=(OTHERS=>'0');END IF;IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII:=(III0II00l1IIlIO100l00OlI1l1O0IIIII-II11OIIIO0I0OI0IIIIO1lOO011IlIIIII)-1+II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII;IF IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII
='1'THEN IIOO1OlIO01I00l0OO0I11OII1OlOIIIII:=-IIOO1OlIO01I00l0OO0I11OII1OlOIIIII;END IF;IIl1O1IllII0I01IlO01l0lII0lIOOIIII:=0;WHILE IIl1O1IllII0I01IlO01l0lII0lIOOIIII<IO0IllIIO11IlI1010IIl0l000001IIIII AND IIOO1OlIO01I00l0OO0I11OII1OlOIIIII(IO0IllIIO11IlI1010IIl0l000001IIIII-2)='0'LOOP IIOO1OlIO01I00l0OO0I11OII1OlOIIIII:=SHL(IIOO1OlIO01I00l0OO0I11OII1OlOIIIII,CONV_UNSIGNED(1,1));
IIl1O1IllII0I01IlO01l0lII0lIOOIIII:=IIl1O1IllII0I01IlO01l0lII0lIOOIIII+1;END LOOP;IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII:=IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII-IIl1O1IllII0I01IlO01l0lII0lIOOIIII;IIO001lIl0II1lI10I1000O00Ol10IIIII:=III0II00l1IIlIO100l00OlI1l1O0IIIII-III101l00lllOOOlIO0OO1lI1OO1OIIIII;IF(IIO001lIl0II1lI10I1000O00Ol10IIIII>0)THEN IIOI1lO0I00III00II0IO0ll0111IOIIII:=(OTHERS=>'0');IIOI1lO0I00III00II0IO0ll0111IOIIII
(IIO001lIl0II1lI10I1000O00Ol10IIIII-1):='1';IF IIOO1OlIO01I00l0OO0I11OII1OlOIIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII-1)='0'THEN ELSE IOI1IOl0OI0O1OllO10lO1lOOl0l1IIIII:=TRUE;IF IIO001lIl0II1lI10I1000O00Ol10IIIII>1 THEN FOR IIII00IOl0llO0O011llO1lOOOIIOIIIII IN 0 TO IIO001lIl0II1lI10I1000O00Ol10IIIII-2 LOOP IF IIOO1OlIO01I00l0OO0I11OII1OlOIIIII(IIII00IOl0llO0O011llO1lOOOIIOIIIII)='1'THEN IOI1IOl0OI0O1OllO10lO1lOOl0l1IIIII:=
FALSE;END IF;END LOOP;END IF;IF IOI1IOl0OI0O1OllO10lO1lOOl0l1IIIII THEN IF IIOO1OlIO01I00l0OO0I11OII1OlOIIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII)='1'THEN IIOO1OlIO01I00l0OO0I11OII1OlOIIIII:=IIOO1OlIO01I00l0OO0I11OII1OlOIIIII+IIOI1lO0I00III00II0IO0ll0111IOIIII;END IF;ELSE IIOO1OlIO01I00l0OO0I11OII1OlOIIIII:=IIOO1OlIO01I00l0OO0I11OII1OlOIIIII+IIOI1lO0I00III00II0IO0ll0111IOIIII;END IF
;END IF;IF(IIOO1OlIO01I00l0OO0I11OII1OlOIIIII(IO0IllIIO11IlI1010IIl0l000001IIIII-1))='1'THEN IIOO1OlIO01I00l0OO0I11OII1OlOIIIII:=SHR(IIOO1OlIO01I00l0OO0I11OII1OlOIIIII,CONV_UNSIGNED(1,1));IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII:=IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII+1;END IF;END IF;IF IIOO1OlIO01I00l0OO0I11OII1OlOIIIII=II1l0I0l10l0I1I1lO01l10I01lI1IIIII THEN III11OII1IlIl1001I1IO1111l0IlIIIII
:=FLT_PT_GET_ZERO(IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII,III101l00lllOOOlIO0OO1lI1OO1OIIIII,'0');ELSIF IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII<IO0OIl1OO10lO00IlIl0Il0l1l1OIIIIII THEN III11OII1IlIl1001I1IO1111l0IlIIIII:=FLT_PT_GET_ZERO(IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII,III101l00lllOOOlIO0OO1lI1OO1OIIIII,IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII);ELSIF IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII>
IO0lllOII000O01100OOI0II1II01IIIII THEN III11OII1IlIl1001I1IO1111l0IlIIIII:=FLT_PT_GET_INF(IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII,III101l00lllOOOlIO0OO1lI1OO1OIIIII,IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII);ELSE IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII:=IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII;III11OII1IlIl1001I1IO1111l0IlIIIII:=IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII&CONV_STD_LOGIC_VECTOR(IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII,IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII
-III101l00lllOOOlIO0OO1lI1OO1OIIIII)&STD_LOGIC_VECTOR(STD_LOGIC_VECTOR(IIOO1OlIO01I00l0OO0I11OII1OlOIIIII(IO0IllIIO11IlI1010IIl0l000001IIIII-3 DOWNTO IO0IllIIO11IlI1010IIl0l000001IIIII-1-III101l00lllOOOlIO0OO1lI1OO1OIIIII)));END IF;IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII:=III11OII1IlIl1001I1IO1111l0IlIIIII;IOO0lOOOll1OI0OI0lI10IOOOII00IIIII:=IIII11lI1lOl0OlOO0II11lI101lOIIIII;
II111O1llOOlI0lOOIIIl0OIlIlllIIIII:=IOl0Ill1OOl0O1IO1l0010I0lO010IIIII;IIO11lIl110IO0lO00IOOl0Il11I1IIIII:=IO0IlOI1OIOO0l101l10IO00l0101IIIII;END;PROCEDURE IIlOIl110lOl10lO1OIllII10IOO1IIIII(IO0O00IOlOOIOO11lI01l000IIIIOIIIII:IN INTEGER;II10I1011llOIIlI00OI0IIIl0OIOIIIII:IN INTEGER;IOI0O1l0101lI100OIOIlll001OO1IIIII:IN INTEGER;IIlI1lIIIOI0l01l01OOII00I0O0lIIIII:IN
 STD_LOGIC_VECTOR(FLT_PT_COMPARE_OPERATION_WIDTH-1 DOWNTO 0);IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII:IN STD_LOGIC_VECTOR;IIl000O0IO0llO0II1lI1010lOO0IOIIII:IN STD_LOGIC_VECTOR;IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII:OUT STD_LOGIC_VECTOR;
IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:OUT STD_LOGIC)IS CONSTANT II1OO01O01O10l0IIOIII101O1000IIIII:INTEGER:=II10I1011llOIIlI00OI0IIIl0OIOIIIII;CONSTANT II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII:INTEGER:=IO0O00IOlOOIOO11lI01l000IIIIOIIIII-II10I1011llOIIlI00OI0IIIl0OIOIIIII;CONSTANT II0I00l0IOOO11I1l0O11O1I1O101IIIII:INTEGER:=2**(II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII-1)-1;VARIABLE
 IOlO0lIIlI010OIO10l11l1l1lIO0IIIII:UNSIGNED(II1OO01O01O10l0IIOIII101O1000IIIII-2 DOWNTO 0);VARIABLE II10010II0ll0l10O0OOI01I11110IIIII:UNSIGNED(II1OO01O01O10l0IIOIII101O1000IIIII-2 DOWNTO 0);VARIABLE IIllIl0lIO10011Ol0O10l01O1Il0IIIII:UNSIGNED(II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII-1 DOWNTO 0);VARIABLE III0lIIl1lO0OI1OlO101lI10lIIIOIIII:UNSIGNED
(II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII-1 DOWNTO 0);VARIABLE IIO01II0O1OlI01l11l10Il10llI0IIIII:STD_LOGIC;VARIABLE IIII10l0Ol001IlOlO1OO1l1llO00IIIII:STD_LOGIC;VARIABLE IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII:BOOLEAN;VARIABLE II0lIllO11Ill0l10OIOI01I00I1OIIIII:BOOLEAN;VARIABLE IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII:
BOOLEAN;VARIABLE IOI1I0l0OllIO01I0O1O001I0lI1IOIIII:BOOLEAN;VARIABLE II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII:STD_LOGIC_VECTOR(3 DOWNTO 0);VARIABLE IIIO01IOl00Il00111I010ll11010IIIII:BOOLEAN;VARIABLE IO000l1I110IOlI1l1OlO00l1011IIIIII:
BOOLEAN;VARIABLE II1l1I00I1OI1Il0l111OOI10l1lIOIIII:STD_LOGIC;VARIABLE II01Il0I0I011lOlIO11Il1l11IOlIIIII:BOOLEAN;VARIABLE IO1O0O0O00O0I0100lIl10OOIlO0OIIIII:BOOLEAN;VARIABLE IIlOlIIOllO0I11I1OlOIlIl1IlOOIIIII:BOOLEAN;VARIABLE IIl111OlOO0lll00IOO01OOIl1l1IIIIII:BOOLEAN;
VARIABLE IIO101OI0lOlOI1IIOllllI10O1lIIIIII:BOOLEAN;VARIABLE IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII:BOOLEAN;BEGIN II01Il0I0I011lOlIO11Il1l11IOlIIIII:=FLT_PT_IS_INF(II1OO01O01O10l0IIOIII101O1000IIIII+II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII,II1OO01O01O10l0IIOIII101O1000IIIII,IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII);IO1O0O0O00O0I0100lIl10OOIlO0OIIIII:=FLT_PT_IS_NAN(II1OO01O01O10l0IIOIII101O1000IIIII+II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII,II1OO01O01O10l0IIOIII101O1000IIIII,IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII);IIlOlIIOllO0I11I1OlOIlIl1IlOOIIIII:=
II1IOOO1II0l1lOl00I1O001I00O0IIIII(II1OO01O01O10l0IIOIII101O1000IIIII+II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII,II1OO01O01O10l0IIOIII101O1000IIIII,IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII);IIl111OlOO0lll00IOO01OOIl1l1IIIIII:=FLT_PT_IS_INF(II1OO01O01O10l0IIOIII101O1000IIIII+II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII,II1OO01O01O10l0IIOIII101O1000IIIII,IIl000O0IO0llO0II1lI1010lOO0IOIIII);IIO101OI0lOlOI1IIOllllI10O1lIIIIII:=FLT_PT_IS_NAN(II1OO01O01O10l0IIOIII101O1000IIIII+II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII,II1OO01O01O10l0IIOIII101O1000IIIII,IIl000O0IO0llO0II1lI1010lOO0IOIIII);IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII:=II1IOOO1II0l1lOl00I1O001I00O0IIIII
(II1OO01O01O10l0IIOIII101O1000IIIII+II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII,II1OO01O01O10l0IIOIII101O1000IIIII,IIl000O0IO0llO0II1lI1010lOO0IOIIII);IIO01II0O1OlI01l11l10Il10llI0IIIII:=IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII(II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII+II1OO01O01O10l0IIOIII101O1000IIIII-1);IIllIl0lIO10011Ol0O10l01O1Il0IIIII:=UNSIGNED(IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII(II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII+II1OO01O01O10l0IIOIII101O1000IIIII-2 DOWNTO II1OO01O01O10l0IIOIII101O1000IIIII-1));IF IIlOlIIOllO0I11I1OlOIlIl1IlOOIIIII THEN IOlO0lIIlI010OIO10l11l1l1lIO0IIIII(II1OO01O01O10l0IIOIII101O1000IIIII-2 DOWNTO 0):=(OTHERS=>'0');ELSE IOlO0lIIlI010OIO10l11l1l1lIO0IIIII
(II1OO01O01O10l0IIOIII101O1000IIIII-2 DOWNTO 0):=UNSIGNED(IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII(II1OO01O01O10l0IIOIII101O1000IIIII-2 DOWNTO 0));END IF;IIII10l0Ol001IlOlO1OO1l1llO00IIIII:=IIl000O0IO0llO0II1lI1010lOO0IOIIII(II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII+II1OO01O01O10l0IIOIII101O1000IIIII-1);III0lIIl1lO0OI1OlO101lI10lIIIOIIII:=UNSIGNED(IIl000O0IO0llO0II1lI1010lOO0IOIIII(II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII+II1OO01O01O10l0IIOIII101O1000IIIII-2 DOWNTO II1OO01O01O10l0IIOIII101O1000IIIII-1));IF IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII THEN II10010II0ll0l10O0OOI01I11110IIIII(II1OO01O01O10l0IIOIII101O1000IIIII
-2 DOWNTO 0):=(OTHERS=>'0');ELSE II10010II0ll0l10O0OOI01I11110IIIII(II1OO01O01O10l0IIOIII101O1000IIIII-2 DOWNTO 0):=UNSIGNED(IIl000O0IO0llO0II1lI1010lOO0IOIIII(II1OO01O01O10l0IIOIII101O1000IIIII-2 DOWNTO 0));END IF;IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII:=FALSE;II0lIllO11Ill0l10OIOI01I00I1OIIIII:=FALSE;IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII:=FALSE;
IOI1I0l0OllIO01I0O1O001I0lI1IOIIII:=FALSE;II1l1I00I1OI1Il0l111OOI10l1lIOIIII:='0';IF(IIO01II0O1OlI01l11l10Il10llI0IIIII='0'AND IIII10l0Ol001IlOlO1OO1l1llO00IIIII='1')THEN IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII:=TRUE;ELSIF(IIO01II0O1OlI01l11l10Il10llI0IIIII='1'AND IIII10l0Ol001IlOlO1OO1l1llO00IIIII='0')THEN II0lIllO11Ill0l10OIOI01I00I1OIIIII:=TRUE;ELSIF(IIllIl0lIO10011Ol0O10l01O1Il0IIIII
/=III0lIIl1lO0OI1OlO101lI10lIIIOIIII)THEN IF(III0lIIl1lO0OI1OlO101lI10lIIIOIIII>IIllIl0lIO10011Ol0O10l01O1Il0IIIII)THEN II0lIllO11Ill0l10OIOI01I00I1OIIIII:=(IIO01II0O1OlI01l11l10Il10llI0IIIII='0');IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII:=(IIO01II0O1OlI01l11l10Il10llI0IIIII='1');ELSE II0lIllO11Ill0l10OIOI01I00I1OIIIII:=(IIO01II0O1OlI01l11l10Il10llI0IIIII='1');IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII:=(IIO01II0O1OlI01l11l10Il10llI0IIIII='0');END IF;ELSE IF
(II10010II0ll0l10O0OOI01I11110IIIII>IOlO0lIIlI010OIO10l11l1l1lIO0IIIII)THEN II0lIllO11Ill0l10OIOI01I00I1OIIIII:=(IIO01II0O1OlI01l11l10Il10llI0IIIII='0');IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII:=(IIO01II0O1OlI01l11l10Il10llI0IIIII='1');ELSE IF(II10010II0ll0l10O0OOI01I11110IIIII/=IOlO0lIIlI010OIO10l11l1l1lIO0IIIII)THEN II0lIllO11Ill0l10OIOI01I00I1OIIIII:=(IIO01II0O1OlI01l11l10Il10llI0IIIII='1');IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII:=(IIO01II0O1OlI01l11l10Il10llI0IIIII='0');ELSE
 IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII:=TRUE;END IF;END IF;END IF;IF IIlOlIIOllO0I11I1OlOIlIl1IlOOIIIII AND IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII THEN IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII:=TRUE;II0lIllO11Ill0l10OIOI01I00I1OIIIII:=FALSE;IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII:=FALSE;END IF;IF IO1O0O0O00O0I0100lIl10OOIlO0OIIIII OR IIO101OI0lOlOI1IIOllllI10O1lIIIIII THEN
 IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII:=FALSE;II0lIllO11Ill0l10OIOI01I00I1OIIIII:=FALSE;IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII:=FALSE;IOI1I0l0OllIO01I0O1O001I0lI1IOIIII:=TRUE;END IF;II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII:=(OTHERS=>'0');IF IIlI1lIIIOI0l01l01OOII00I0O0lIIIII="111"THEN IF IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII THEN II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII(0):=
'1';END IF;IF II0lIllO11Ill0l10OIOI01I00I1OIIIII THEN II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII(1):='1';END IF;IF IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII THEN II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII(2):='1';END IF;IF IOI1I0l0OllIO01I0O1O001I0lI1IOIIII THEN II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII(3):='1';END IF;ELSIF((
IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII AND(IIlI1lIIIOI0l01l01OOII00I0O0lIIIII(2)='1'))OR(IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII AND(IIlI1lIIIOI0l01l01OOII00I0O0lIIIII(1)='1'))OR(II0lIllO11Ill0l10OIOI01I00I1OIIIII AND(IIlI1lIIIOI0l01l01OOII00I0O0lIIIII(0)='1')))THEN II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII(0):='1';ELSIF(IIlI1lIIIOI0l01l01OOII00I0O0lIIIII="000")THEN IF
(IOI1I0l0OllIO01I0O1O001I0lI1IOIIII)THEN II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII(0):='1';END IF;END IF;IF(IIlI1lIIIOI0l01l01OOII00I0O0lIIIII/="111"AND((IOI1I0l0OllIO01I0O1O001I0lI1IOIIII AND NOT(IIlI1lIIIOI0l01l01OOII00I0O0lIIIII="000"OR IIlI1lIIIOI0l01l01OOII00I0O0lIIIII="010"OR IIlI1lIIIOI0l01l01OOII00I0O0lIIIII="101"))))THEN
 II1l1I00I1OI1Il0l111OOI10l1lIOIIII:='1';II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII(0):='0';END IF;IF(IOI1I0l0OllIO01I0O1O001I0lI1IOIIII AND IIlI1lIIIOI0l01l01OOII00I0O0lIIIII="101")THEN II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII(0):='1';END IF;IF IOI0O1l0101lI100OIOIlll001OO1IIIII>4 THEN IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII(3 DOWNTO 0):=II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII
;FOR II00lO01O111Ol1OOIllOOl110OOIIIIII IN 4 TO IOI0O1l0101lI100OIOIlll001OO1IIIII-1 LOOP IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII(II00lO01O111Ol1OOIllOOl110OOIIIIII):='0';END LOOP;ELSE IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII:=II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII(IOI0O1l0101lI100OIOIlll001OO1IIIII-1 DOWNTO 0);END IF;IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:=II1l1I00I1OI1Il0l111OOI10l1lIOIIII;END;PROCEDURE
 IIO00IlOO0lO0l1OO0l00lOOI0lO0IIIII(III110I0l00l0lOl000OOI0I1IOlIOIIII:IN STD_LOGIC_VECTOR(C_A_WIDTH-1 DOWNTO 0);IIOI0III1IIlI00OOOI1I100OOIIOOIIII:IN STD_LOGIC_VECTOR(C_B_WIDTH-1 DOWNTO 0);IIIIOO0llOIll1IO0lIlO0l111O0IOIIII:IN STD_LOGIC_VECTOR(
FLT_PT_OPERATION_WIDTH-1 DOWNTO 0);IO0O1OIIlI0I0101llOI1O01OOIIOOIIII:OUT STD_LOGIC_VECTOR(C_RESULT_WIDTH-1 DOWNTO 0);IOOOOI1lIlOlI10IOOOI00O10O00IIIIII:OUT STD_LOGIC;II1O1lIOOI00OOI10010I1010IOOOIIIII:OUT
 STD_LOGIC;IOO0IlOlIOOll110I1l0O0011lllIOIIII:OUT STD_LOGIC;IOOl1IIO0I01ll0O00O01O1I000IOIIIII:OUT STD_LOGIC)IS VARIABLE IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII:STD_LOGIC_VECTOR(C_RESULT_WIDTH-1 DOWNTO 0):=
(OTHERS=>'0');VARIABLE III1lI0IOlOO11l0lO0IIl00OlOl0IIIII:STD_LOGIC;VARIABLE IIO1lIlIlIIll0011II00OlO00llOIIIII:STD_LOGIC;VARIABLE IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII:STD_LOGIC;VARIABLE
 IIOl00111100II1IOl0O1OO1I0lIOOIIII:STD_LOGIC;VARIABLE II101I1OIIl111101l00ll0Ol1l01IIIII:BOOLEAN;BEGIN III1lI0IOlOO11l0lO0IIl00OlOl0IIIII:='0';IIO1lIlIlIIll0011II00OlO00llOIIIII:='0';IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII:='0';
IIOl00111100II1IOl0O1OO1I0lIOOIIII:='0';II101I1OIIl111101l00ll0Ol1l01IIIII:=FALSE;CASE CONV_INTEGER(UNSIGNED(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII(FLT_PT_OP_CODE_SLICE)))IS WHEN FLT_PT_SQRT_OP_CODE=>IF(
C_HAS_SQRT=FLT_PT_YES)THEN IF((C_RESULT_WIDTH=C_A_WIDTH)AND(C_RESULT_FRACTION_WIDTH=C_A_FRACTION_WIDTH))THEN II1001IO0010Oll1I01lOI0I0IlIOIIIII(
C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH,III110I0l00l0lOl000OOI0I1IOlIOIIII,IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII,III1lI0IOlOO11l0lO0IIl00OlOl0IIIII,IIO1lIlIlIIll0011II00OlO00llOIIIII,IIOl00111100II1IOl0O1OO1I0lIOOIIII);II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;END IF;ELSIF(
C_HAS_FLT_TO_FLT=FLT_PT_YES)THEN IOO01O011lIIIlOl1O0lOIOOI110IOIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH,III110I0l00l0lOl000OOI0I1IOlIOIIII,IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII,
III1lI0IOlOO11l0lO0IIl00OlOl0IIIII,IIO1lIlIlIIll0011II00OlO00llOIIIII,IIOl00111100II1IOl0O1OO1I0lIOOIIII);II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;END IF;WHEN FLT_PT_DIVIDE_OP_CODE=>IF(C_HAS_DIVIDE=FLT_PT_YES)THEN
 IOIlII1I0O0l1l1O110O0IOlO0O1lIIIII(C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH,III110I0l00l0lOl000OOI0I1IOlIOIIII,IIOI0III1IIlI00OOOI1I100OOIIOOIIII,IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII,III1lI0IOlOO11l0lO0IIl00OlOl0IIIII,IIO1lIlIlIIll0011II00OlO00llOIIIII,IIOl00111100II1IOl0O1OO1I0lIOOIIII,IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII);
II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;END IF;WHEN FLT_PT_MULTIPLY_OP_CODE=>IF(C_HAS_MULTIPLY=FLT_PT_YES)THEN II1011O1IO1l0llOI11lIIOIlOlIlIIIII(C_RESULT_WIDTH,
C_RESULT_FRACTION_WIDTH,III110I0l00l0lOl000OOI0I1IOlIOIIII,IIOI0III1IIlI00OOOI1I100OOIIOOIIII,IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII,III1lI0IOlOO11l0lO0IIl00OlOl0IIIII,IIO1lIlIlIIll0011II00OlO00llOIIIII,IIOl00111100II1IOl0O1OO1I0lIOOIIII);II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;END IF;WHEN FLT_PT_ADD_OP_CODE
=>IF C_HAS_ADD=FLT_PT_TRUE THEN IOIO1OI0IlI1I1010lO000IO01Ol0IIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,FALSE,III110I0l00l0lOl000OOI0I1IOlIOIIII,IIOI0III1IIlI00OOOI1I100OOIIOOIIII,IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII,III1lI0IOlOO11l0lO0IIl00OlOl0IIIII,IIO1lIlIlIIll0011II00OlO00llOIIIII,
IIOl00111100II1IOl0O1OO1I0lIOOIIII);II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;END IF;WHEN FLT_PT_SUBTRACT_OP_CODE=>IF C_HAS_SUBTRACT=FLT_PT_TRUE THEN IOIO1OI0IlI1I1010lO000IO01Ol0IIIII(C_A_WIDTH,
C_A_FRACTION_WIDTH,TRUE,III110I0l00l0lOl000OOI0I1IOlIOIIII,IIOI0III1IIlI00OOOI1I100OOIIOOIIII,IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII,III1lI0IOlOO11l0lO0IIl00OlOl0IIIII,IIO1lIlIlIIll0011II00OlO00llOIIIII,IIOl00111100II1IOl0O1OO1I0lIOOIIII);II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;END IF;WHEN
 FLT_PT_COMPARE_OP_CODE=>IF(C_HAS_COMPARE=FLT_PT_YES)THEN IIlOIl110lOl10lO1OIllII10IOO1IIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,C_RESULT_WIDTH,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII(
FLT_PT_COMPARE_OPERATION_SLICE),III110I0l00l0lOl000OOI0I1IOlIOIIII,IIOI0III1IIlI00OOOI1I100OOIIOOIIII,IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII,III1lI0IOlOO11l0lO0IIl00OlOl0IIIII);II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;END IF;WHEN FLT_PT_FLT_TO_FIX_OP_CODE=>IF(
C_HAS_FLT_TO_FIX=FLT_PT_YES)THEN IF C_OPTIMIZATION=FLT_PT_COMBINED THEN IF(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII(FLT_PT_SPECIAL_SLICE)='1'AND(C_RESULT_WIDTH=64 AND
 C_RESULT_FRACTION_WIDTH=53))THEN IO1l01O110OIl00l10lOOlI0lI0I0IIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,C_RESULT_WIDTH/2,0,III110I0l00l0lOl000OOI0I1IOlIOIIII,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII(FLT_PT_ROUND_MODE_SLICE),
IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII(C_RESULT_WIDTH/2-1 DOWNTO 0),III1lI0IOlOO11l0lO0IIl00OlOl0IIIII,IIO1lIlIlIIll0011II00OlO00llOIIIII,IIOl00111100II1IOl0O1OO1I0lIOOIIII);IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII(C_RESULT_WIDTH-1 DOWNTO C_RESULT_WIDTH
/2):=(OTHERS=>'0');II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;ELSE IO1l01O110OIl00l10lOOlI0lI0I0IIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,C_RESULT_WIDTH,0,III110I0l00l0lOl000OOI0I1IOlIOIIII,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII(
FLT_PT_ROUND_MODE_SLICE),IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII,III1lI0IOlOO11l0lO0IIl00OlOl0IIIII,IIO1lIlIlIIll0011II00OlO00llOIIIII,IIOl00111100II1IOl0O1OO1I0lIOOIIII);II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;END IF;ELSE IO1l01O110OIl00l10lOOlI0lI0I0IIIII(
C_A_WIDTH,C_A_FRACTION_WIDTH,C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH,III110I0l00l0lOl000OOI0I1IOlIOIIII,FLT_PT_RND_TO_NEAREST_EVEN_SLV,IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII,III1lI0IOlOO11l0lO0IIl00OlOl0IIIII,
IIO1lIlIlIIll0011II00OlO00llOIIIII,IIOl00111100II1IOl0O1OO1I0lIOOIIII);II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;END IF;END IF;WHEN FLT_PT_FIX_TO_FLT_OP_CODE=>IF(C_HAS_FIX_TO_FLT=FLT_PT_YES)THEN IF
 C_OPTIMIZATION=FLT_PT_COMBINED THEN II1ll1Il1Il11O10OllIl0l1l1l0IOIIII(C_A_WIDTH,0,C_A_WIDTH,C_A_FRACTION_WIDTH,III110I0l00l0lOl000OOI0I1IOlIOIIII,IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII,III1lI0IOlOO11l0lO0IIl00OlOl0IIIII,
IIO1lIlIlIIll0011II00OlO00llOIIIII,IIOl00111100II1IOl0O1OO1I0lIOOIIII);II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;ELSE II1ll1Il1Il11O10OllIl0l1l1l0IOIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,C_RESULT_WIDTH,
C_RESULT_FRACTION_WIDTH,III110I0l00l0lOl000OOI0I1IOlIOIIII,IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII,III1lI0IOlOO11l0lO0IIl00OlOl0IIIII,IIO1lIlIlIIll0011II00OlO00llOIIIII,IIOl00111100II1IOl0O1OO1I0lIOOIIII);II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;END IF;END IF;WHEN OTHERS=>END
 CASE;IF II101I1OIIl111101l00ll0Ol1l01IIIII THEN IO0O1OIIlI0I0101llOI1O01OOIIOOIIII:=IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII;IOOOOI1lIlOlI10IOOOI00O10O00IIIIII:=III1lI0IOlOO11l0lO0IIl00OlOl0IIIII;II1O1lIOOI00OOI10010I1010IOOOIIIII:=IIO1lIlIlIIll0011II00OlO00llOIIIII;IOO0IlOlIOOll110I1l0O0011lllIOIIII:=IIOl00111100II1IOl0O1OO1I0lIOOIIII;
IOOl1IIO0I01ll0O00O01O1I000IOIIIII:=IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII;ELSE IO0O1OIIlI0I0101llOI1O01OOIIOOIIII:=(OTHERS=>'X');IOOOOI1lIlOlI10IOOOI00O10O00IIIIII:='X';II1O1lIOOI00OOI10010I1010IOOOIIIII:='X';IOO0IlOlIOOll110I1l0O0011lllIOIIII:='X';IOOl1IIO0I01ll0O00O01O1I000IOIIIII:='X';END
 IF;END;CONSTANT IO1ll0OlO000O0lIO01I1llIOlOI1IIIII:STD_LOGIC_VECTOR(FLT_PT_OP_CODE_SLICE):=FLT_PT_GET_OP_CODE(C_HAS_ADD,C_HAS_SUBTRACT,C_HAS_MULTIPLY,
C_HAS_DIVIDE,C_HAS_SQRT,C_HAS_COMPARE,C_HAS_FIX_TO_FLT,C_HAS_FLT_TO_FIX,C_HAS_FLT_TO_FLT);CONSTANT IOI111lOI111OOlI0III1I0lO1I0IIIIII:INTEGER:=FLT_PT_DELAY(
FAMILY=>C_XDEVICEFAMILY,OP_CODE=>IO1ll0OlO000O0lIO01I1llIOlOI1IIIII,A_WIDTH=>C_A_WIDTH,A_FRACTION_WIDTH=>C_A_FRACTION_WIDTH,B_WIDTH=>C_B_WIDTH,
B_FRACTION_WIDTH=>C_B_FRACTION_WIDTH,RESULT_WIDTH=>C_RESULT_WIDTH,RESULT_FRACTION_WIDTH=>C_RESULT_FRACTION_WIDTH,OPTIMIZATION=>
C_OPTIMIZATION,MULT_USAGE=>C_MULT_USAGE,RATE=>C_RATE,HAS_ADD=>C_HAS_ADD,HAS_SUBTRACT=>C_HAS_SUBTRACT,HAS_MULTIPLY=>C_HAS_MULTIPLY,
HAS_DIVIDE=>C_HAS_DIVIDE,HAS_SQRT=>C_HAS_SQRT,HAS_COMPARE=>C_HAS_COMPARE,HAS_FLT_TO_FIX=>C_HAS_FLT_TO_FIX,HAS_FIX_TO_FLT=>
C_HAS_FIX_TO_FLT,HAS_FLT_TO_FLT=>C_HAS_FLT_TO_FLT,REQUIRED=>C_LATENCY);SIGNAL IOl0l0l0I0I0l0I010011l0llIl1lIIIII:STD_LOGIC:='0';SIGNAL IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII:
STD_LOGIC:='1';SIGNAL II001lI100O0O0I1l1IIOlIlO00IlIIIII:STD_LOGIC;SIGNAL IO1Ol0OlIIO11llOOl00IIIO11101IIIII:STD_LOGIC:='0';BEGIN II001lI100O0O0I1l1IIOlIlO00IlIIIII<=(IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII
 AND OPERATION_ND)WHEN IOI111lOI111OOlI0III1I0lO1I0IIIIII=0 ELSE(IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII AND OPERATION_ND AND NOT(SCLR));RDF_GEN:PROCESS(CLK)VARIABLE IOl0I1IOO010I0II10OOIl1ll1Ol1IIIII:BOOLEAN
:=FALSE;VARIABLE II0O01100OIIIl10O1OIl0I00Ol10IIIII:NATURAL RANGE 0 TO C_RATE-1;BEGIN IF IOI111lOI111OOlI0III1I0lO1I0IIIIII=0 THEN IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII<='1';ELSIF RISING_EDGE(CLK)THEN IF
 SCLR='1'THEN IOl0I1IOO010I0II10OOIl1ll1Ol1IIIII:=FALSE;IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII<='0';ELSIF CE='1'THEN IF C_RATE>1 THEN IF II001lI100O0O0I1l1IIOlIlO00IlIIIII='1'THEN IOl0I1IOO010I0II10OOIl1ll1Ol1IIIII:=TRUE;
II0O01100OIIIl10O1OIl0I00Ol10IIIII:=C_RATE-1;ELSIF II0O01100OIIIl10O1OIl0I00Ol10IIIII=0 THEN IOl0I1IOO010I0II10OOIl1ll1Ol1IIIII:=FALSE;END IF;IF IOl0I1IOO010I0II10OOIl1ll1Ol1IIIII THEN II0O01100OIIIl10O1OIl0I00Ol10IIIII:=II0O01100OIIIl10O1OIl0I00Ol10IIIII-1;END IF;END IF;IF IOl0I1IOO010I0II10OOIl1ll1Ol1IIIII
 THEN IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII<='0';ELSE IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII<='1';END IF;END IF;END IF;END PROCESS;DELAY_0:IF IOI111lOI111OOlI0III1I0lO1I0IIIIII=0 GENERATE IOl0l0l0I0I0l0I010011l0llIl1lIIIII<=
II001lI100O0O0I1l1IIOlIlO00IlIIIII;PROCESS(A,B,OPERATION)VARIABLE II1I1IOl0I0I1I0lIl00ll11I111OIIIII:STD_LOGIC_VECTOR(C_RESULT_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');VARIABLE
 IO0O010II00IOl10I10O1l0I10O1IOIIII:STD_LOGIC:='0';VARIABLE II11OlI0I00OIO1llOI00O0lI0OlIIIIII:STD_LOGIC:='0';VARIABLE IO1I1OO00O1lIOOIll0lIO0l10lIlIIIII:STD_LOGIC:='0';VARIABLE
 IOOlII11IOO011lOll1IOO10O010OIIIII:STD_LOGIC:='0';BEGIN IIO00IlOO0lO0l1OO0l00lOOI0lO0IIIII(III110I0l00l0lOl000OOI0I1IOlIOIIII=>A,IIOI0III1IIlI00OOOI1I100OOIIOOIIII=>B,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII=>OPERATION,IO0O1OIIlI0I0101llOI1O01OOIIOOIIII=>II1I1IOl0I0I1I0lIl00ll11I111OIIIII,IOOOOI1lIlOlI10IOOOI00O10O00IIIIII=>IO0O010II00IOl10I10O1l0I10O1IOIIII,II1O1lIOOI00OOI10010I1010IOOOIIIII=>
II11OlI0I00OIO1llOI00O0lI0OlIIIIII,IOO0IlOlIOOll110I1l0O0011lllIOIIII=>IO1I1OO00O1lIOOIll0lIO0l10lIlIIIII,IOOl1IIO0I01ll0O00O01O1I000IOIIIII=>IOOlII11IOO011lOll1IOO10O010OIIIII);RESULT<=II1I1IOl0I0I1I0lIl00ll11I111OIIIII;INVALID_OP<=IO0O010II00IOl10I10O1l0I10O1IOIIII;OVERFLOW<=
II11OlI0I00OIO1llOI00O0lI0OlIIIIII;UNDERFLOW<=IO1I1OO00O1lIOOIll0lIO0l10lIlIIIII;DIVIDE_BY_ZERO<=IOOlII11IOO011lOll1IOO10O010OIIIII;STATUS<=IO0O010II00IOl10I10O1l0I10O1IOIIII&IOOlII11IOO011lOll1IOO10O010OIIIII&II11OlI0I00OIO1llOI00O0lI0OlIIIIII&
IO1I1OO00O1lIOOIll0lIO0l10lIlIIIII&'0';END PROCESS;END GENERATE;DELAY_N:IF IOI111lOI111OOlI0III1I0lO1I0IIIIII/=0 GENERATE BEGIN DELAY_INPUT:PROCESS(CLK)TYPE IOI1IlOO001111I101I1O01l01lI1IIIII IS ARRAY(
NATURAL RANGE<>)OF STD_LOGIC_VECTOR(C_RESULT_WIDTH-1 DOWNTO 0);VARIABLE II1l0l1O010I00O1Ill1O10lIII0OIIIII:IOI1IlOO001111I101I1O01l01lI1IIIII(0 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII):=(OTHERS=>(OTHERS=>'0')
);VARIABLE IO0Oll001000I1I0IIOO101lI10lIIIIII:STD_LOGIC_VECTOR(1 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII):=(OTHERS=>'0');VARIABLE IOI0IlOIlO11lO1OO1ll111101lO1IIIII:STD_LOGIC_VECTOR(0 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII):=(OTHERS=>
'0');VARIABLE IIIlO001lO010I00O0OOllOO00l01IIIII:STD_LOGIC_VECTOR(0 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII):=(OTHERS=>'0');VARIABLE IOlII0O0Oll1OO0O1O0O0O111O00lIIIII:STD_LOGIC_VECTOR(0 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII):=(
OTHERS=>'0');VARIABLE IOO1ll00l01O0lI100l10I1OOl0IIOIIII:STD_LOGIC_VECTOR(0 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII):=(OTHERS=>'0');BEGIN IF RISING_EDGE(CLK)THEN IF SCLR='1'THEN
 IO0Oll001000I1I0IIOO101lI10lIIIIII:=(OTHERS=>'0');IOl0l0l0I0I0l0I010011l0llIl1lIIIII<='0';ELSIF CE='1'THEN IO0Oll001000I1I0IIOO101lI10lIIIIII(1 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII):=II001lI100O0O0I1l1IIOlIlO00IlIIIII&IO0Oll001000I1I0IIOO101lI10lIIIIII(1 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII-1);IOl0l0l0I0I0l0I010011l0llIl1lIIIII<=
IO0Oll001000I1I0IIOO101lI10lIIIIII(IOI111lOI111OOlI0III1I0lO1I0IIIIII);END IF;IF CE='1'THEN IIO00IlOO0lO0l1OO0l00lOOI0lO0IIIII(III110I0l00l0lOl000OOI0I1IOlIOIIII=>A,IIOI0III1IIlI00OOOI1I100OOIIOOIIII=>B,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII=>OPERATION,IO0O1OIIlI0I0101llOI1O01OOIIOOIIII=>II1l0l1O010I00O1Ill1O10lIII0OIIIII(0),IOOOOI1lIlOlI10IOOOI00O10O00IIIIII=>IOI0IlOIlO11lO1OO1ll111101lO1IIIII(0),
II1O1lIOOI00OOI10010I1010IOOOIIIII=>IIIlO001lO010I00O0OOllOO00l01IIIII(0),IOO0IlOlIOOll110I1l0O0011lllIOIIII=>IOlII0O0Oll1OO0O1O0O0O111O00lIIIII(0),IOOl1IIO0I01ll0O00O01O1I000IOIIIII=>IOO1ll00l01O0lI100l10I1OOl0IIOIIII(0));II1l0l1O010I00O1Ill1O10lIII0OIIIII(1 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII):=
II1l0l1O010I00O1Ill1O10lIII0OIIIII(0 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII-1);IOI0IlOIlO11lO1OO1ll111101lO1IIIII(1 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII):=IOI0IlOIlO11lO1OO1ll111101lO1IIIII(0 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII-1);IIIlO001lO010I00O0OOllOO00l01IIIII(1 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII):=IIIlO001lO010I00O0OOllOO00l01IIIII(0
 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII-1);IOlII0O0Oll1OO0O1O0O0O111O00lIIIII(1 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII):=IOlII0O0Oll1OO0O1O0O0O111O00lIIIII(0 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII-1);IOO1ll00l01O0lI100l10I1OOl0IIOIIII(1 TO IOI111lOI111OOlI0III1I0lO1I0IIIIII):=IOO1ll00l01O0lI100l10I1OOl0IIOIIII(0 TO
 IOI111lOI111OOlI0III1I0lO1I0IIIIII-1);RESULT<=II1l0l1O010I00O1Ill1O10lIII0OIIIII(IOI111lOI111OOlI0III1I0lO1I0IIIIII);INVALID_OP<=IOI0IlOIlO11lO1OO1ll111101lO1IIIII(IOI111lOI111OOlI0III1I0lO1I0IIIIII);OVERFLOW<=IIIlO001lO010I00O0OOllOO00l01IIIII(IOI111lOI111OOlI0III1I0lO1I0IIIIII);UNDERFLOW<=IOlII0O0Oll1OO0O1O0O0O111O00lIIIII
(IOI111lOI111OOlI0III1I0lO1I0IIIIII);DIVIDE_BY_ZERO<=IOO1ll00l01O0lI100l10I1OOl0IIOIIII(IOI111lOI111OOlI0III1I0lO1I0IIIIII);STATUS<=IOI0IlOIlO11lO1OO1ll111101lO1IIIII(IOI111lOI111OOlI0III1I0lO1I0IIIIII)&IOO1ll00l01O0lI100l10I1OOl0IIOIIII(IOI111lOI111OOlI0III1I0lO1I0IIIIII)&IIIlO001lO010I00O0OOllOO00l01IIIII(IOI111lOI111OOlI0III1I0lO1I0IIIIII
)&IOlII0O0Oll1OO0O1O0O0O111O00lIIIII(IOI111lOI111OOlI0III1I0lO1I0IIIIII)&'0';END IF;END IF;END PROCESS;END GENERATE;OPERATION_RFD<=IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII;RDY<=IOl0l0l0I0I0l0I010011l0llIl1lIIIII;END;LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;USE IEEE.STD_LOGIC_ARITH.ALL;LIBRARY XILINXCORELIB;USE XILINXCORELIB.FLOATING_POINT_V5_0_CONSTS.ALL;USE
 XILINXCORELIB.FLOATING_POINT_PKG_V5_0.ALL;ENTITY FLOATING_POINT_V5_0_XST IS GENERIC(C_XDEVICEFAMILY:STRING:=C_XDEVICEFAMILY_DEFAULT
;C_HAS_ADD:INTEGER:=C_HAS_ADD_DEFAULT;C_HAS_SUBTRACT:INTEGER:=C_HAS_SUBTRACT_DEFAULT;C_HAS_MULTIPLY:INTEGER:=C_HAS_MULTIPLY_DEFAULT
;C_HAS_DIVIDE:INTEGER:=C_HAS_DIVIDE_DEFAULT;C_HAS_SQRT:INTEGER:=C_HAS_SQRT_DEFAULT;C_HAS_COMPARE:INTEGER:=C_HAS_COMPARE_DEFAULT;
C_HAS_FIX_TO_FLT:INTEGER:=C_HAS_FIX_TO_FLT_DEFAULT;C_HAS_FLT_TO_FIX:INTEGER:=C_HAS_FLT_TO_FIX_DEFAULT;C_HAS_FLT_TO_FLT:INTEGER:=
C_HAS_FLT_TO_FLT_DEFAULT;C_A_WIDTH:INTEGER:=C_A_WIDTH_DEFAULT;C_A_FRACTION_WIDTH:INTEGER:=C_A_FRACTION_WIDTH_DEFAULT;C_B_WIDTH:
INTEGER:=C_B_WIDTH_DEFAULT;C_B_FRACTION_WIDTH:INTEGER:=C_B_FRACTION_WIDTH_DEFAULT;C_RESULT_WIDTH:INTEGER:=C_RESULT_WIDTH_DEFAULT;
C_RESULT_FRACTION_WIDTH:INTEGER:=C_RESULT_FRACTION_WIDTH_DEFAULT;C_COMPARE_OPERATION:INTEGER:=C_COMPARE_OPERATION_DEFAULT;C_LATENCY
:INTEGER:=C_LATENCY_DEFAULT;C_OPTIMIZATION:INTEGER:=C_OPTIMIZATION_DEFAULT;C_MULT_USAGE:INTEGER:=C_MULT_USAGE_DEFAULT;C_RATE:INTEGER
:=C_RATE_DEFAULT;C_HAS_ACLR:INTEGER:=C_HAS_ACLR_DEFAULT;C_HAS_CE:INTEGER:=C_HAS_CE_DEFAULT;C_HAS_SCLR:INTEGER:=C_HAS_SCLR_DEFAULT;
C_HAS_A_NEGATE:INTEGER:=C_HAS_A_NEGATE_DEFAULT;C_HAS_B_NEGATE:INTEGER:=C_HAS_B_NEGATE_DEFAULT;C_HAS_A_ND:INTEGER:=C_HAS_A_ND_DEFAULT
;C_HAS_A_RFD:INTEGER:=C_HAS_A_RFD_DEFAULT;C_HAS_B_ND:INTEGER:=C_HAS_B_ND_DEFAULT;C_HAS_B_RFD:INTEGER:=C_HAS_B_RFD_DEFAULT;
C_HAS_OPERATION_ND:INTEGER:=C_HAS_OPERATION_ND_DEFAULT;C_HAS_OPERATION_RFD:INTEGER:=C_HAS_OPERATION_RFD_DEFAULT;C_HAS_RDY:INTEGER:=
C_HAS_RDY_DEFAULT;C_HAS_CTS:INTEGER:=C_HAS_CTS_DEFAULT;C_HAS_UNDERFLOW:INTEGER:=C_HAS_UNDERFLOW_DEFAULT;C_HAS_OVERFLOW:INTEGER:=
C_HAS_OVERFLOW_DEFAULT;C_HAS_INVALID_OP:INTEGER:=C_HAS_INVALID_OP_DEFAULT;C_HAS_INEXACT:INTEGER:=C_HAS_INEXACT_DEFAULT;
C_HAS_DIVIDE_BY_ZERO:INTEGER:=C_HAS_DIVIDE_BY_ZERO_DEFAULT;C_HAS_STATUS:INTEGER:=C_HAS_STATUS_DEFAULT;C_HAS_EXCEPTION:INTEGER:=
C_HAS_EXCEPTION_DEFAULT;C_STATUS_EARLY:INTEGER:=C_STATUS_EARLY_DEFAULT;C_SPEED:INTEGER:=C_SPEED_DEFAULT;C_ROUNDING_MODE:INTEGER:=
FLT_PT_RND_TO_NEAREST_EVEN);PORT(A:IN STD_LOGIC_VECTOR(C_A_WIDTH-1 DOWNTO 0);B:IN STD_LOGIC_VECTOR(C_B_WIDTH-1 DOWNTO 0):=(OTHERS=>
'0');A_NEGATE:IN STD_LOGIC:='0';B_NEGATE:IN STD_LOGIC:='0';OPERATION:IN STD_LOGIC_VECTOR(FLT_PT_OPERATION_WIDTH-1 DOWNTO 0):=(OTHERS
=>'0');A_ND:IN STD_LOGIC:='1';A_RFD:OUT STD_LOGIC;B_ND:IN STD_LOGIC:='1';B_RFD:OUT STD_LOGIC;OPERATION_ND:IN STD_LOGIC:='1';
OPERATION_RFD:OUT STD_LOGIC;CLK:IN STD_LOGIC;SCLR:IN STD_LOGIC:='0';ACLR:IN STD_LOGIC:='0';CE:IN STD_LOGIC:='1';RESULT:OUT
 STD_LOGIC_VECTOR(C_RESULT_WIDTH-1 DOWNTO 0);STATUS:OUT STD_LOGIC_VECTOR(FLT_PT_STATUS_WIDTH-1 DOWNTO 0);EXCEPTION:OUT STD_LOGIC;
UNDERFLOW:OUT STD_LOGIC;OVERFLOW:OUT STD_LOGIC;INVALID_OP:OUT STD_LOGIC;INEXACT:OUT STD_LOGIC;DIVIDE_BY_ZERO:OUT STD_LOGIC;RDY:OUT
 STD_LOGIC;CTS:IN STD_LOGIC:='1');END;ARCHITECTURE BEHAVIORAL OF FLOATING_POINT_V5_0_XST IS COMPONENT FLT_PT_OPERATOR_V5_0 GENERIC(
C_XDEVICEFAMILY:STRING:=C_XDEVICEFAMILY_DEFAULT;C_HAS_ADD:INTEGER:=C_HAS_ADD_DEFAULT;C_HAS_SUBTRACT:INTEGER:=C_HAS_SUBTRACT_DEFAULT
;C_HAS_MULTIPLY:INTEGER:=C_HAS_MULTIPLY_DEFAULT;C_HAS_DIVIDE:INTEGER:=C_HAS_DIVIDE_DEFAULT;C_HAS_SQRT:INTEGER:=C_HAS_SQRT_DEFAULT;
C_HAS_COMPARE:INTEGER:=C_HAS_COMPARE_DEFAULT;C_HAS_FIX_TO_FLT:INTEGER:=C_HAS_FIX_TO_FLT_DEFAULT;C_HAS_FLT_TO_FIX:INTEGER:=
C_HAS_FLT_TO_FIX_DEFAULT;C_HAS_FLT_TO_FLT:INTEGER:=C_HAS_FLT_TO_FLT_DEFAULT;C_A_WIDTH:INTEGER:=C_A_WIDTH_DEFAULT;C_A_FRACTION_WIDTH
:INTEGER:=C_A_FRACTION_WIDTH_DEFAULT;C_B_WIDTH:INTEGER:=C_B_WIDTH_DEFAULT;C_B_FRACTION_WIDTH:INTEGER:=C_B_FRACTION_WIDTH_DEFAULT;
C_RESULT_WIDTH:INTEGER:=C_RESULT_WIDTH_DEFAULT;C_RESULT_FRACTION_WIDTH:INTEGER:=C_RESULT_FRACTION_WIDTH_DEFAULT;C_COMPARE_OPERATION
:INTEGER:=C_COMPARE_OPERATION_DEFAULT;C_LATENCY:INTEGER:=C_LATENCY_DEFAULT;C_OPTIMIZATION:INTEGER:=C_OPTIMIZATION_DEFAULT;
C_MULT_USAGE:INTEGER:=C_MULT_USAGE_DEFAULT;C_RATE:INTEGER:=C_RATE_DEFAULT;C_HAS_ACLR:INTEGER:=C_HAS_ACLR_DEFAULT;C_HAS_CE:INTEGER:=
C_HAS_CE_DEFAULT;C_HAS_SCLR:INTEGER:=C_HAS_SCLR_DEFAULT;C_HAS_A_NEGATE:INTEGER:=C_HAS_A_NEGATE_DEFAULT;C_HAS_B_NEGATE:INTEGER:=
C_HAS_B_NEGATE_DEFAULT;C_HAS_A_ND:INTEGER:=C_HAS_A_ND_DEFAULT;C_HAS_A_RFD:INTEGER:=C_HAS_A_RFD_DEFAULT;C_HAS_B_ND:INTEGER:=
C_HAS_B_ND_DEFAULT;C_HAS_B_RFD:INTEGER:=C_HAS_B_RFD_DEFAULT;C_HAS_OPERATION_ND:INTEGER:=C_HAS_OPERATION_ND_DEFAULT;
C_HAS_OPERATION_RFD:INTEGER:=C_HAS_OPERATION_RFD_DEFAULT;C_HAS_RDY:INTEGER:=C_HAS_RDY_DEFAULT;C_HAS_CTS:INTEGER:=C_HAS_CTS_DEFAULT;
C_HAS_UNDERFLOW:INTEGER:=C_HAS_UNDERFLOW_DEFAULT;C_HAS_OVERFLOW:INTEGER:=C_HAS_OVERFLOW_DEFAULT;C_HAS_INVALID_OP:INTEGER:=
C_HAS_INVALID_OP_DEFAULT;C_HAS_INEXACT:INTEGER:=C_HAS_INEXACT_DEFAULT;C_HAS_DIVIDE_BY_ZERO:INTEGER:=C_HAS_DIVIDE_BY_ZERO_DEFAULT;
C_HAS_STATUS:INTEGER:=C_HAS_STATUS_DEFAULT;C_HAS_EXCEPTION:INTEGER:=C_HAS_EXCEPTION_DEFAULT;C_STATUS_EARLY:INTEGER:=
C_STATUS_EARLY_DEFAULT;C_SPEED:INTEGER:=C_SPEED_DEFAULT;C_ROUNDING_MODE:INTEGER:=FLT_PT_RND_TO_NEAREST_EVEN);PORT(A:IN
 STD_LOGIC_VECTOR(C_A_WIDTH-1 DOWNTO 0);B:IN STD_LOGIC_VECTOR(C_B_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');A_NEGATE:IN STD_LOGIC:='0';
B_NEGATE:IN STD_LOGIC:='0';OPERATION:IN STD_LOGIC_VECTOR(FLT_PT_OPERATION_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');A_ND:IN STD_LOGIC:='1';
A_RFD:OUT STD_LOGIC;B_ND:IN STD_LOGIC:='1';B_RFD:OUT STD_LOGIC;OPERATION_ND:IN STD_LOGIC:='1';OPERATION_RFD:OUT STD_LOGIC;CLK:IN
 STD_LOGIC;SCLR:IN STD_LOGIC:='0';ACLR:IN STD_LOGIC:='0';CE:IN STD_LOGIC:='1';RESULT:OUT STD_LOGIC_VECTOR(C_RESULT_WIDTH-1 DOWNTO 0
):=(OTHERS=>'0');STATUS:OUT STD_LOGIC_VECTOR(FLT_PT_STATUS_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');EXCEPTION:OUT STD_LOGIC;UNDERFLOW:OUT
 STD_LOGIC:='0';OVERFLOW:OUT STD_LOGIC:='0';INVALID_OP:OUT STD_LOGIC:='0';INEXACT:OUT STD_LOGIC;DIVIDE_BY_ZERO:OUT STD_LOGIC:='0';
RDY:OUT STD_LOGIC;CTS:IN STD_LOGIC:='1');END COMPONENT;CONSTANT IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII:BOOLEAN:=FLOATING_POINT_V5_0_CHECK(C_XDEVICEFAMILY=>
C_XDEVICEFAMILY,C_HAS_ADD=>C_HAS_ADD,C_HAS_SUBTRACT=>C_HAS_SUBTRACT,C_HAS_MULTIPLY=>C_HAS_MULTIPLY,C_HAS_DIVIDE=>C_HAS_DIVIDE,
C_HAS_SQRT=>C_HAS_SQRT,C_HAS_COMPARE=>C_HAS_COMPARE,C_HAS_FLT_TO_FIX=>C_HAS_FLT_TO_FIX,C_HAS_FIX_TO_FLT=>C_HAS_FIX_TO_FLT,
C_HAS_FLT_TO_FLT=>C_HAS_FLT_TO_FLT,C_A_WIDTH=>C_A_WIDTH,C_A_FRACTION_WIDTH=>C_A_FRACTION_WIDTH,C_B_WIDTH=>C_B_WIDTH,
C_B_FRACTION_WIDTH=>C_B_FRACTION_WIDTH,C_RESULT_WIDTH=>C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH=>C_RESULT_FRACTION_WIDTH,
C_COMPARE_OPERATION=>C_COMPARE_OPERATION,C_OPTIMIZATION=>C_OPTIMIZATION,C_MULT_USAGE=>C_MULT_USAGE,C_LATENCY=>C_LATENCY,C_RATE=>
C_RATE,C_HAS_SCLR=>C_HAS_SCLR,C_HAS_CE=>C_HAS_CE,C_HAS_OPERATION_ND=>C_HAS_OPERATION_ND,C_HAS_OPERATION_RFD=>C_HAS_OPERATION_RFD,
C_HAS_RDY=>C_HAS_RDY,C_HAS_UNDERFLOW=>C_HAS_UNDERFLOW,C_HAS_OVERFLOW=>C_HAS_OVERFLOW,C_HAS_INVALID_OP=>C_HAS_INVALID_OP,
C_HAS_DIVIDE_BY_ZERO=>C_HAS_DIVIDE_BY_ZERO,C_HAS_EXCEPTION=>C_HAS_EXCEPTION,C_STATUS_EARLY=>C_STATUS_EARLY,C_SPEED=>C_SPEED);
CONSTANT IOI111OlI111O1lI0lO1I00O0II10IIIII:INTEGER:=FLT_PT_NUMBER_OF_OPERATIONS(C_HAS_ADD,C_HAS_SUBTRACT,C_HAS_MULTIPLY,C_HAS_DIVIDE,C_HAS_SQRT,
C_HAS_COMPARE,C_HAS_FIX_TO_FLT,C_HAS_FLT_TO_FIX,C_HAS_FLT_TO_FLT);CONSTANT IIOI01II0OIl10O10OO010OIOllO0IIIII:INTEGER:=FLT_PT_HAS_B(C_HAS_ADD,C_HAS_SUBTRACT,
C_HAS_MULTIPLY,C_HAS_DIVIDE,C_HAS_SQRT,C_HAS_COMPARE,C_HAS_FIX_TO_FLT,C_HAS_FLT_TO_FIX,C_HAS_FLT_TO_FLT);SIGNAL IOO0l1O1IlO1000Ol10IlOIO00111IIIII:
STD_LOGIC;SIGNAL IOO0O01Il01I00O00IO0O0O1ll0O1IIIII:STD_LOGIC;SIGNAL IOOIl01IO0lllOIIlIO10l11I000lIIIII:STD_LOGIC;SIGNAL III00lO01IIlOIllO00O0lIll1O1IIIIII:STD_LOGIC;SIGNAL IOlOI110lOlOI0OI11O000OOIl1IOIIIII:STD_LOGIC;
SIGNAL IO101lI0lO1OI00OIOO1lOI1l1lIIOIIII:STD_LOGIC;SIGNAL III11I1OOl0l0IIOIIIOOOIOl0010IIIII:STD_LOGIC;SIGNAL IOlI00lO001l0IlOIOIlO11IOl011IIIII:STD_LOGIC;SIGNAL IO1O0l0lO001lll1111lO1lOl100OIIIII:STD_LOGIC;SIGNAL IOIIOO0OlOOll0II1IOOI0IO0Il11IIIII
:STD_LOGIC_VECTOR(FLT_PT_STATUS_WIDTH-1 DOWNTO 0);SIGNAL IOIOlOOOOl01l0I1l0OI1Il1l1OO1IIIII:STD_LOGIC;SIGNAL IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII:STD_LOGIC_VECTOR(
FLT_PT_OPERATION_WIDTH-1 DOWNTO 0);SIGNAL II0I110I0IllOO1l11O1I0llOlOI1IIIII:STD_LOGIC_VECTOR(C_B_WIDTH-1 DOWNTO 0);BEGIN ASSERT(C_ROUNDING_MODE=
FLT_PT_RND_TO_NEAREST_EVEN)REPORT"ERROR in floating_point_v5_0 behavioural model: C_ROUNDING_MODE not supported."&
" Can only take the value FLT_PT_RND_TO_NEAREST_EVEN."SEVERITY FAILURE;YES_B:IF IIOI01II0OIl10O10OO010OIOllO0IIIII=FLT_PT_YES GENERATE II0I110I0IllOO1l11O1I0llOlOI1IIIII<=B;END GENERATE;NO_B
:IF IIOI01II0OIl10O10OO010OIOllO0IIIII/=FLT_PT_YES GENERATE II0I110I0IllOO1l11O1I0llOlOI1IIIII<=(OTHERS=>'0');END GENERATE;YES_CE:IF C_HAS_CE=FLT_PT_YES GENERATE IOlOI110lOlOI0OI11O000OOIl1IOIIIII<=CE;END GENERATE;NO_CE
:IF C_HAS_CE/=FLT_PT_YES GENERATE IOlOI110lOlOI0OI11O000OOIl1IOIIIII<='1';END GENERATE;YES_SCLR:IF C_HAS_SCLR=FLT_PT_YES GENERATE IO101lI0lO1OI00OIOO1lOI1l1lIIOIIII<=SCLR;END GENERATE;
NO_SCLR:IF C_HAS_SCLR/=FLT_PT_YES GENERATE IO101lI0lO1OI00OIOO1lOI1l1lIIOIIII<='0';END GENERATE;YES_OPERATION_ND:IF C_HAS_OPERATION_ND=FLT_PT_YES GENERATE
 III11I1OOl0l0IIOIIIOOOIOl0010IIIII<=OPERATION_ND;END GENERATE;NO_OPERATION_ND:IF C_HAS_OPERATION_ND/=FLT_PT_YES GENERATE III11I1OOl0l0IIOIIIOOOIOl0010IIIII<='1';END
 GENERATE;YES_OPERATION_RFD:IF C_HAS_OPERATION_RFD=FLT_PT_YES GENERATE OPERATION_RFD<=IOlI00lO001l0IlOIOIlO11IOl011IIIII;END GENERATE;NO_OPERATION_RFD
:IF C_HAS_OPERATION_RFD/=FLT_PT_YES GENERATE OPERATION_RFD<='X';END GENERATE;YES_RDY:IF C_HAS_RDY=FLT_PT_YES GENERATE RDY<=IO1O0l0lO001lll1111lO1lOl100OIIIII;
END GENERATE;NO_RDY:IF C_HAS_RDY/=FLT_PT_YES GENERATE RDY<='X';END GENERATE;YES_UNDERFLOW:IF C_HAS_UNDERFLOW=FLT_PT_YES GENERATE
 UNDERFLOW<=IOO0l1O1IlO1000Ol10IlOIO00111IIIII;END GENERATE;NO_UNDERFLOW:IF C_HAS_UNDERFLOW/=FLT_PT_YES GENERATE UNDERFLOW<='X';END GENERATE;YES_OVERFLOW
:IF C_HAS_OVERFLOW=FLT_PT_YES GENERATE OVERFLOW<=IOO0O01Il01I00O00IO0O0O1ll0O1IIIII;END GENERATE;NO_OVERFLOW:IF C_HAS_OVERFLOW/=FLT_PT_YES GENERATE
 OVERFLOW<='X';END GENERATE;YES_INVALID_OP:IF C_HAS_INVALID_OP=FLT_PT_YES GENERATE INVALID_OP<=III00lO01IIlOIllO00O0lIll1O1IIIIII;END GENERATE;
NO_INVALID_OP:IF C_HAS_INVALID_OP/=FLT_PT_YES GENERATE INVALID_OP<='X';END GENERATE;YES_DIVIDE_BY_ZERO:IF(C_HAS_DIVIDE_BY_ZERO=
FLT_PT_YES)GENERATE DIVIDE_BY_ZERO<=IOOIl01IO0lllOIIlIO10l11I000lIIIII;END GENERATE;NO_DIVIDE_BY_ZERO:IF(C_HAS_DIVIDE_BY_ZERO/=FLT_PT_YES)GENERATE
 DIVIDE_BY_ZERO<='X';END GENERATE;YES_EXCEPTION:IF C_HAS_EXCEPTION=FLT_PT_YES GENERATE EXCEPTION<=IOIOlOOOOl01l0I1l0OI1Il1l1OO1IIIII;END GENERATE;
NO_EXCEPTION:IF C_HAS_EXCEPTION/=FLT_PT_YES GENERATE EXCEPTION<='X';END GENERATE;YES_STATUS:IF C_HAS_STATUS=FLT_PT_YES GENERATE
 STATUS<=IOIIOO0OlOOll0II1IOOI0IO0Il11IIIII;END GENERATE;NO_STATUS:IF C_HAS_STATUS=FLT_PT_NO GENERATE STATUS<=(OTHERS=>'X');END GENERATE;OPERATION_RQD:IF
 IOI111OlI111O1lI0lO1I00O0II10IIIII>1 GENERATE IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII(FLT_PT_OP_CODE_SLICE)<=OPERATION(FLT_PT_OP_CODE_SLICE);END GENERATE;ONE_OPERATION:IF
 IOI111OlI111O1lI0lO1I00O0II10IIIII=1 GENERATE CONSTANT IOI1000Ol10O11I01I0O1lIII0OlIIIIII:STD_LOGIC_VECTOR(FLT_PT_OP_CODE_SLICE):=FLT_PT_GET_OP_CODE(C_HAS_ADD,
C_HAS_SUBTRACT,C_HAS_MULTIPLY,C_HAS_DIVIDE,C_HAS_SQRT,C_HAS_COMPARE,C_HAS_FIX_TO_FLT,C_HAS_FLT_TO_FIX,C_HAS_FLT_TO_FLT);BEGIN
 IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII(FLT_PT_OP_CODE_SLICE)<=IOI1000Ol10O11I01I0O1lIII0OlIIIIII;END GENERATE;YES_COMPARE:IF C_HAS_COMPARE=FLT_PT_YES GENERATE PROG_COMPARE:IF
 C_COMPARE_OPERATION=FLT_PT_PROGRAMMABLE GENERATE IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII(FLT_PT_OPERATION_WIDTH-1 DOWNTO FLT_PT_OPERATION_WIDTH-
FLT_PT_COMPARE_OPERATION_WIDTH)<=OPERATION(FLT_PT_OPERATION_WIDTH-1 DOWNTO FLT_PT_OPERATION_WIDTH-FLT_PT_COMPARE_OPERATION_WIDTH);
END GENERATE;FIXED_COMPARE:IF C_COMPARE_OPERATION/=FLT_PT_PROGRAMMABLE GENERATE IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII(FLT_PT_OPERATION_WIDTH-1 DOWNTO
 FLT_PT_OPERATION_WIDTH-FLT_PT_COMPARE_OPERATION_WIDTH)<=CONV_STD_LOGIC_VECTOR(C_COMPARE_OPERATION,FLT_PT_COMPARE_OPERATION_WIDTH);
END GENERATE;END GENERATE;NO_COMPARE:IF C_HAS_COMPARE=FLT_PT_NO GENERATE YES_SPECIAL:IF C_OPTIMIZATION=FLT_PT_COMBINED GENERATE
 IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII(FLT_PT_SPECIAL_SLICE)<=OPERATION(FLT_PT_SPECIAL_SLICE);END GENERATE;NO_SPECIAL:IF NOT(C_OPTIMIZATION=FLT_PT_COMBINED)
GENERATE IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII(FLT_PT_SPECIAL_SLICE)<='0';END GENERATE;YES_ROUND_MODE:IF C_ROUNDING_MODE/=FLT_PT_RND_TO_NEAREST_EVEN OR
 C_OPTIMIZATION=FLT_PT_COMBINED GENERATE IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII(FLT_PT_ROUND_MODE_SLICE)<=OPERATION(FLT_PT_ROUND_MODE_SLICE);END GENERATE;
NO_ROUND_MODE:IF NOT(C_ROUNDING_MODE/=FLT_PT_RND_TO_NEAREST_EVEN OR C_OPTIMIZATION=FLT_PT_COMBINED)GENERATE IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII(
FLT_PT_ROUND_MODE_SLICE)<=FLT_PT_RND_TO_NEAREST_EVEN_SLV;END GENERATE;END GENERATE;FP_OP:FLT_PT_OPERATOR_V5_0 GENERIC MAP(
C_XDEVICEFAMILY=>C_XDEVICEFAMILY,C_HAS_ADD=>C_HAS_ADD,C_HAS_SUBTRACT=>C_HAS_SUBTRACT,C_HAS_MULTIPLY=>C_HAS_MULTIPLY,C_HAS_DIVIDE=>
C_HAS_DIVIDE,C_HAS_SQRT=>C_HAS_SQRT,C_HAS_COMPARE=>C_HAS_COMPARE,C_HAS_FIX_TO_FLT=>C_HAS_FIX_TO_FLT,C_HAS_FLT_TO_FIX=>
C_HAS_FLT_TO_FIX,C_HAS_FLT_TO_FLT=>C_HAS_FLT_TO_FLT,C_RESULT_WIDTH=>C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH=>C_RESULT_FRACTION_WIDTH
,C_A_WIDTH=>C_A_WIDTH,C_A_FRACTION_WIDTH=>C_A_FRACTION_WIDTH,C_B_WIDTH=>C_B_WIDTH,C_B_FRACTION_WIDTH=>C_B_FRACTION_WIDTH,
C_OPTIMIZATION=>C_OPTIMIZATION,C_MULT_USAGE=>C_MULT_USAGE,C_HAS_STATUS=>C_HAS_STATUS,C_STATUS_EARLY=>C_STATUS_EARLY,C_LATENCY=>
C_LATENCY,C_RATE=>C_RATE,C_ROUNDING_MODE=>C_ROUNDING_MODE)PORT MAP(A=>A,B=>II0I110I0IllOO1l11O1I0llOlOI1IIIII,OPERATION=>IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII,OPERATION_ND=>
III11I1OOl0l0IIOIIIOOOIOl0010IIIII,OPERATION_RFD=>IOlI00lO001l0IlOIOIlO11IOl011IIIII,CLK=>CLK,CE=>IOlOI110lOlOI0OI11O000OOIl1IOIIIII,SCLR=>IO101lI0lO1OI00OIOO1lOI1l1lIIOIIII,RESULT=>RESULT,STATUS=>IOIIOO0OlOOll0II1IOOI0IO0Il11IIIII,EXCEPTION=>
IOIOlOOOOl01l0I1l0OI1Il1l1OO1IIIII,UNDERFLOW=>IOO0l1O1IlO1000Ol10IlOIO00111IIIII,OVERFLOW=>IOO0O01Il01I00O00IO0O0O1ll0O1IIIII,INVALID_OP=>III00lO01IIlOIllO00O0lIll1O1IIIIII,DIVIDE_BY_ZERO=>IOOIl01IO0lllOIIlIO10l11I000lIIIII,RDY=>IO1O0l0lO001lll1111lO1lOl100OIIIII);
END;
